/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.composer.MessageComposer;

public class OutboundHandler
extends BaseHandler {
    private final MessageComposer<Message> _messageComposer;
    private final ProducerTemplate _producerTemplate;
    private final CamelContext _camelContext;
    private final String _uri;

    public OutboundHandler(String uri, CamelContext context, MessageComposer<Message> messageComposer) {
        if (uri == null) {
            throw new IllegalArgumentException("uri argument must not be null");
        }
        this._uri = uri;
        if (context == null) {
            throw new IllegalArgumentException("camelContext argument must not be null");
        }
        this._camelContext = context;
        this._producerTemplate = this._camelContext.createProducerTemplate();
        this._messageComposer = messageComposer;
    }

    public void stop() throws Exception {
        this._producerTemplate.stop();
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (this.isInOnly(exchange)) {
            this.handleInOnly(exchange);
        } else {
            this.handleInOut(exchange);
        }
    }

    private boolean isInOnly(Exchange exchange) {
        return exchange.getContract().getServiceOperation().getExchangePattern() == ExchangePattern.IN_ONLY;
    }

    private void handleInOnly(Exchange exchange) throws HandlerException {
        try {
            this._producerTemplate.send(this._uri, this.createProcessor(exchange));
        }
        catch (CamelExecutionException e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void handleInOut(Exchange switchyardExchange) throws HandlerException {
        try {
            Object payload = this.sendToCamel(switchyardExchange);
            this.sendResponseToSwitchyard(switchyardExchange, payload);
        }
        catch (CamelExecutionException e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private Object sendToCamel(Exchange switchyardExchange) {
        org.apache.camel.Exchange camelExchange = this._producerTemplate.request(this._uri, this.createProcessor(switchyardExchange));
        return camelExchange.getOut().getBody();
    }

    private void sendResponseToSwitchyard(Exchange switchyardExchange, Object payload) {
        switchyardExchange.getMessage().setContent(payload);
        switchyardExchange.send(switchyardExchange.getMessage());
    }

    private Processor createProcessor(final Exchange switchyardExchange) {
        return new Processor(){

            public void process(org.apache.camel.Exchange camelExchange) throws Exception {
                OutboundHandler.this._messageComposer.decompose(switchyardExchange, (Object)camelExchange.getIn());
            }
        };
    }

    public void handleFault(Exchange exchange) {
        super.handleFault(exchange);
    }

    public CamelContext getCamelContext() {
        return this._camelContext;
    }

    public String getUri() {
        return this._uri;
    }
}

