/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.exchange;

import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.drools.persistence.jta.JtaTransactionManager;
import org.jbpm.persistence.JpaProcessPersistenceContextManager;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.KieInternalServices;
import org.kie.event.KieRuntimeEventManager;
import org.kie.process.CorrelationAwareProcessRuntime;
import org.kie.process.CorrelationKey;
import org.kie.process.CorrelationKeyFactory;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.ProcessRuntime;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bpm.BPMActionType;
import org.switchyard.component.bpm.BPMConstants;
import org.switchyard.component.bpm.config.model.BPMComponentImplementationModel;
import org.switchyard.component.bpm.exchange.BPMProcessEventListener;
import org.switchyard.component.bpm.transaction.AS7TransactionHelper;
import org.switchyard.component.bpm.util.WorkItemHandlers;
import org.switchyard.component.common.knowledge.ActionType;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.exchange.KnowledgeAction;
import org.switchyard.component.common.knowledge.exchange.KnowledgeExchangeHandler;
import org.switchyard.component.common.knowledge.session.KnowledgeSession;
import org.switchyard.component.common.knowledge.util.Actions;
import org.switchyard.component.common.knowledge.util.Disposals;
import org.switchyard.component.common.knowledge.util.Environments;
import org.switchyard.component.common.knowledge.util.Listeners;

public class BPMExchangeHandler
extends KnowledgeExchangeHandler<BPMComponentImplementationModel> {
    private static final KnowledgeAction DEFAULT_ACTION = new KnowledgeAction((ActionType)BPMActionType.START_PROCESS);
    private final boolean _persistent;
    private final String _processId;
    private final BPMProcessEventListener _processEventListener;
    private CorrelationKeyFactory _correlationKeyFactory;
    private EntityManagerFactory _entityManagerFactory;

    public BPMExchangeHandler(BPMComponentImplementationModel model, ServiceDomain domain) {
        super((KnowledgeComponentImplementationModel)model, domain);
        this._persistent = model.isPersistent();
        this._processId = model.getProcessId();
        this._processEventListener = new BPMProcessEventListener(domain.getEventPublisher());
    }

    public void start() {
        this._correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        if (this._persistent) {
            this._entityManagerFactory = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        }
        super.start();
    }

    public void stop() {
        this._correlationKeyFactory = null;
        if (this._entityManagerFactory != null) {
            Disposals.newDisposal((EntityManagerFactory)this._entityManagerFactory).dispose();
            this._entityManagerFactory = null;
        }
        super.stop();
    }

    protected Properties getPropertyOverrides() {
        return super.getPropertyOverrides();
    }

    protected Map<String, Object> getEnvironmentOverrides() {
        if (this._persistent) {
            UserTransaction ut = AS7TransactionHelper.getUserTransaction();
            TransactionManager tm = AS7TransactionHelper.getTransactionManager();
            HashMap<String, Object> env = new HashMap<String, Object>();
            env.put("org.kie.persistence.jpa.EntityManagerFactory", this._entityManagerFactory);
            env.put("org.kie.transaction.Transaction", ut);
            env.put("org.kie.transaction.TransactionManager", new JtaTransactionManager((Object)ut, null, (Object)tm));
            env.put("org.kie.persistence.PersistenceContextManager", new JpaProcessPersistenceContextManager(Environments.getEnvironment(env)));
            return env;
        }
        return super.getEnvironmentOverrides();
    }

    public KnowledgeAction getDefaultAction() {
        return DEFAULT_ACTION;
    }

    public void handleAction(Exchange exchange, KnowledgeAction action) throws HandlerException {
        Message inputMessage = exchange.getMessage();
        Message outputMessage = null;
        AS7TransactionHelper utx = new AS7TransactionHelper(this._persistent);
        ExchangePattern exchangePattern = exchange.getContract().getProviderOperation().getExchangePattern();
        BPMActionType actionType = (BPMActionType)action.getType();
        switch (actionType) {
            case START_PROCESS: {
                try {
                    utx.begin();
                    KnowledgeSession session = this.getBPMSession(exchange);
                    Actions.setGlobals((Message)inputMessage, (KnowledgeAction)action, (KnowledgeSession)session);
                    Map inputMap = Actions.getInputMap((Message)inputMessage, (KnowledgeAction)action);
                    CorrelationKey correlationKey = this.getCorrelationKey(exchange);
                    ProcessInstance processInstance = correlationKey != null ? ((CorrelationAwareProcessRuntime)session.getStateful()).startProcess(this._processId, correlationKey, inputMap) : session.getStateful().startProcess(this._processId, inputMap);
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        outputMessage = this.handleOutput(exchange, action, session, processInstance);
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            case SIGNAL_EVENT: {
                try {
                    utx.begin();
                    KnowledgeSession session = this.getBPMSession(exchange);
                    Actions.setGlobals((Message)inputMessage, (KnowledgeAction)action, (KnowledgeSession)session);
                    Long processInstanceId = this.getProcessInstanceId(exchange, session);
                    Object eventObject = Actions.getInput((Message)inputMessage, (KnowledgeAction)action);
                    String eventId = action.getEventId();
                    if (processInstanceId != null) {
                        session.getStateful().signalEvent(eventId, eventObject, processInstanceId.longValue());
                    } else {
                        session.getStateful().signalEvent(eventId, eventObject);
                    }
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        ProcessInstance processInstance = session.getStateful().getProcessInstance(processInstanceId.longValue());
                        outputMessage = this.handleOutput(exchange, action, session, processInstance);
                    }
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            case ABORT_PROCESS_INSTANCE: {
                try {
                    utx.begin();
                    KnowledgeSession session = this.getBPMSession(exchange);
                    Long processInstanceId = this.getProcessInstanceId(exchange, session);
                    if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                        ProcessInstance processInstance = session.getStateful().getProcessInstance(processInstanceId.longValue());
                        outputMessage = this.handleOutput(exchange, action, session, processInstance);
                    }
                    session.getStateful().abortProcessInstance(processInstanceId.longValue());
                    utx.commit();
                    break;
                }
                catch (RuntimeException re) {
                    utx.rollback();
                    throw re;
                }
            }
            default: {
                throw new HandlerException("Unsupported action type: " + (Object)((Object)actionType));
            }
        }
        if (outputMessage != null) {
            exchange.send(outputMessage);
        }
    }

    private KnowledgeSession getBPMSession(Exchange exchange) {
        KnowledgeSession session;
        if (this._persistent) {
            Integer sessionId = this.getInteger(exchange, BPMConstants.SESSION_ID_PROPERTY);
            session = this.getPersistentSession(sessionId);
        } else {
            session = this.getStatefulSession();
        }
        Listeners.registerListener((EventListener)((Object)this._processEventListener), (KieRuntimeEventManager)session.getStateful());
        WorkItemHandlers.registerWorkItemHandlers((BPMComponentImplementationModel)this.getModel(), this.getLoader(), (ProcessRuntime)session.getStateful(), this.getDomain());
        return session;
    }

    private Long getProcessInstanceId(Exchange exchange, KnowledgeSession session) {
        long pid;
        ProcessInstance processInstance;
        CorrelationKey correlationKey;
        Long processInstanceId = this.getLong(exchange, BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY);
        if (processInstanceId == null && (correlationKey = this.getCorrelationKey(exchange)) != null && (processInstance = ((CorrelationAwareProcessRuntime)session.getStateful()).getProcessInstance(correlationKey)) != null && (pid = processInstance.getId()) > 0L) {
            processInstanceId = pid;
        }
        return processInstanceId;
    }

    private CorrelationKey getCorrelationKey(Exchange exchange) {
        List properties;
        String ckp = this.getString(exchange, BPMConstants.CORRELATION_KEY_PROPERTY);
        if (ckp != null && (properties = Strings.splitTrimToNull((String)ckp, (String)" \t\n\r\f")).size() > 0) {
            return this._correlationKeyFactory.newCorrelationKey(properties);
        }
        return null;
    }

    private Message handleOutput(Exchange exchange, KnowledgeAction action, KnowledgeSession session, ProcessInstance processInstance) {
        Message outputMessage = exchange.createMessage();
        Integer sessionId = session.getId();
        if (sessionId != null && sessionId > 0) {
            exchange.getContext(outputMessage).setProperty(BPMConstants.SESSION_ID_PROPERTY, (Object)sessionId);
        }
        HashMap contextOverrides = new HashMap();
        if (processInstance != null) {
            Map processInstanceVariables;
            long processInstanceId = processInstance.getId();
            if (processInstanceId > 0L) {
                exchange.getContext(outputMessage).setProperty(BPMConstants.PROCESSS_INSTANCE_ID_PROPERTY, (Object)processInstanceId);
            }
            if (processInstance instanceof WorkflowProcessInstanceImpl && (processInstanceVariables = ((WorkflowProcessInstanceImpl)processInstance).getVariables()) != null) {
                contextOverrides.putAll(processInstanceVariables);
            }
        }
        Actions.setOutputs((Message)outputMessage, (KnowledgeAction)action, contextOverrides);
        return outputMessage;
    }
}

