/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.switchyard.component.bean.ClientProxyBean;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaDataCDIBean;
import org.switchyard.component.bean.deploy.CDIBean;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.exception.SwitchYardException;

public class BeanDeploymentMetaData {
    private BeanManager _beanManager;
    private ClassLoader _deploymentClassLoader;
    private List<ServiceDescriptor> _serviceDescriptors = new ArrayList<ServiceDescriptor>();
    private List<ClientProxyBean> _clientProxies = new ArrayList<ClientProxyBean>();
    private List<CDIBean> _deploymentBeans = new ArrayList<CDIBean>();

    public BeanDeploymentMetaData setBeanManager(BeanManager beanManager) {
        this._beanManager = beanManager;
        return this;
    }

    public BeanManager getBeanManager() {
        return this._beanManager;
    }

    public BeanDeploymentMetaData setDeploymentClassLoader(ClassLoader deploymentClassLoader) {
        this._deploymentClassLoader = deploymentClassLoader;
        return this;
    }

    public ClassLoader getDeploymentClassLoader() {
        return this._deploymentClassLoader;
    }

    public void addServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this._serviceDescriptors.add(serviceDescriptor);
    }

    public void addClientProxy(ClientProxyBean proxy) {
        this._clientProxies.add(proxy);
    }

    public void addDeploymentBean(CDIBean bean) {
        this._deploymentBeans.add(bean);
    }

    public List<ServiceDescriptor> getServiceDescriptors() {
        return Collections.unmodifiableList(this._serviceDescriptors);
    }

    public List<ClientProxyBean> getClientProxies() {
        return Collections.unmodifiableList(this._clientProxies);
    }

    public List<CDIBean> getDeploymentBeans() {
        return Collections.unmodifiableList(this._deploymentBeans);
    }

    public static BeanDeploymentMetaData lookupBeanDeploymentMetaData() {
        try {
            BeanManager beanManager = BeanDeploymentMetaData.getCDIBeanManager();
            Set beans = beanManager.getBeans(BeanDeploymentMetaData.class, new Annotation[0]);
            if (beans.isEmpty()) {
                throw new SwitchYardException("Failed to lookup BeanDeploymentMetaData from BeanManager.  Must be bound into BeanManager.  Perhaps SwitchYard CDI Extensions not properly installed in container.");
            }
            if (beans.size() > 1) {
                throw new SwitchYardException("Failed to lookup BeanDeploymentMetaData from BeanManager.  Multiple beans resolved for type '" + BeanDeploymentMetaData.class.getName() + "'.");
            }
            BeanDeploymentMetaDataCDIBean bean = (BeanDeploymentMetaDataCDIBean)beans.iterator().next();
            return bean.getBeanMetaData();
        }
        catch (NamingException e) {
            throw new SwitchYardException("Failed to lookup BeanManager.  Must be bound into java:comp as per CDI specification.", (Throwable)e);
        }
    }

    public static BeanManager getCDIBeanManager() throws NamingException {
        BeanManager beanManager = BeanDeploymentMetaData.getCDIBeanManager("java:comp");
        if (beanManager == null && (beanManager = BeanDeploymentMetaData.getCDIBeanManager("java:comp/env")) == null) {
            throw new NameNotFoundException("Name BeanManager is not bound in this Context");
        }
        return beanManager;
    }

    private static BeanManager getCDIBeanManager(String jndiLocation) {
        Context javaComp = BeanDeploymentMetaData.getJavaComp(jndiLocation);
        if (javaComp != null) {
            try {
                return (BeanManager)javaComp.lookup("BeanManager");
            }
            catch (NamingException e) {
                return null;
            }
        }
        return null;
    }

    private static Context getJavaComp(String jndiName) {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup(jndiName);
            return context;
        }
        catch (NamingException e) {
            Context context = null;
            return context;
        }
        catch (Exception e) {
            throw new SwitchYardException("Unexpected Exception retrieving '" + jndiName + "' from JNDI namespace.", (Throwable)e);
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException e) {
                    throw new SwitchYardException("Unexpected error closing InitialContext.", (Throwable)e);
                }
            }
        }
    }
}

