/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean.deploy;

import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.switchyard.ExchangeHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.bean.BeanServiceMetadata;
import org.switchyard.component.bean.Service;
import org.switchyard.component.bean.ServiceProxyHandler;
import org.switchyard.component.bean.deploy.BeanDeploymentMetaData;
import org.switchyard.component.bean.deploy.CDIBean;
import org.switchyard.component.bean.deploy.ServiceDescriptor;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;

public class CDIBeanServiceDescriptor
implements ServiceDescriptor {
    private final CDIBean _cdiBean;
    private final BeanDeploymentMetaData _beanDeploymentMetaData;
    private final String _serviceName;
    private final BeanServiceMetadata _serviceMetadata;

    public CDIBeanServiceDescriptor(CDIBean cdiBean, BeanDeploymentMetaData beanDeploymentMetaData) {
        this._cdiBean = cdiBean;
        this._beanDeploymentMetaData = beanDeploymentMetaData;
        Class beanClass = cdiBean.getBean().getBeanClass();
        this._serviceName = this.getServiceName(beanClass);
        this._serviceMetadata = new BeanServiceMetadata(CDIBeanServiceDescriptor.getServiceInterface(beanClass));
    }

    public CDIBean getCDIBean() {
        return this._cdiBean;
    }

    @Override
    public String getServiceName() {
        return this._serviceName;
    }

    public BeanServiceMetadata getServiceMetadata() {
        return this._serviceMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeHandler getHandler() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._beanDeploymentMetaData.getDeploymentClassLoader());
            BeanManager beanManager = this._cdiBean.getBeanManager();
            CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)this._cdiBean.getBean());
            Object beanRef = beanManager.getReference(this._cdiBean.getBean(), Object.class, creationalContext);
            ServiceProxyHandler serviceProxyHandler = new ServiceProxyHandler(beanRef, this._serviceMetadata, this._beanDeploymentMetaData);
            return serviceProxyHandler;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    @Override
    public ServiceInterface getInterface() {
        return JavaService.fromClass(this._serviceMetadata.getServiceClass());
    }

    private String getServiceName(Class<?> beanClass) {
        Service service = beanClass.getAnnotation(Service.class);
        String name = Strings.trimToNull((String)service.name());
        if (name == null) {
            name = CDIBeanServiceDescriptor.getServiceInterface(beanClass).getSimpleName();
        }
        return name;
    }

    protected static Class<?> getServiceInterface(Class<?> beanClass) {
        Service serviceAnnotation = beanClass.getAnnotation(Service.class);
        Class<?> serviceInterface = serviceAnnotation.value();
        if (serviceInterface == null) {
            throw new SwitchYardException("Unexpected exception.  The @Service annotation requires a Service interface Class value to be defined, yet the annotation has no value.");
        }
        if (!serviceInterface.isInterface()) {
            throw new SwitchYardException("Invalid @Service specification @Service(" + serviceInterface.getName() + ".class).  @Service interface Class must be a Java Interface.  Cannot be a concrete implementation.");
        }
        return serviceInterface;
    }
}

