/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.switchyard.Exchange;
import org.switchyard.component.bean.BeanComponentException;
import org.switchyard.component.bean.Invocation;

public class BeanServiceMetadata {
    private Class<? extends Object> _serviceClass;
    private List<Method> _serviceMethods = new ArrayList<Method>();

    public BeanServiceMetadata(Class<? extends Object> serviceClass) {
        Method[] serviceMethods;
        for (Method serviceMethod : serviceMethods = serviceClass.getMethods()) {
            if (serviceMethod.getDeclaringClass() == Object.class) continue;
            this._serviceMethods.add(serviceMethod);
        }
        this._serviceClass = serviceClass;
    }

    public Class<? extends Object> getServiceClass() {
        return this._serviceClass;
    }

    public Invocation getInvocation(Exchange exchange) throws BeanComponentException {
        String operationName = exchange.getContract().getServiceOperation().getName();
        if (operationName != null) {
            List<Method> candidateMethods = this.getCandidateMethods(operationName);
            if (candidateMethods.size() != 1) {
                throw new BeanComponentException("Operation name '" + operationName + "' must resolve to exactly one bean method on bean type '" + this._serviceClass.getName() + "'.");
            }
            Method operationMethod = candidateMethods.get(0);
            return new Invocation(operationMethod, exchange);
        }
        throw new BeanComponentException("Operation name not specified on exchange.");
    }

    public List<Method> getCandidateMethods(String operationName) {
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        for (Method serviceMethod : this._serviceMethods) {
            if (!serviceMethod.getName().equals(operationName)) continue;
            candidateMethods.add(serviceMethod);
        }
        return candidateMethods;
    }
}

