/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.text.Html;
import android.text.Spannable;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.text.style.QuoteSpan;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import java.io.InputStream;
import java.util.Scanner;
import org.sufficientlysecure.htmltextview.ClickableTableSpan;
import org.sufficientlysecure.htmltextview.DesignQuoteSpan;
import org.sufficientlysecure.htmltextview.DrawTableLinkSpan;
import org.sufficientlysecure.htmltextview.HtmlFormatter;
import org.sufficientlysecure.htmltextview.JellyBeanSpanFixTextView;
import org.sufficientlysecure.htmltextview.LocalLinkMovementMethod;
import org.sufficientlysecure.htmltextview.OnClickATagListener;
import org.sufficientlysecure.htmltextview.R;

public class HtmlTextView
extends JellyBeanSpanFixTextView {
    public static final String TAG = "HtmlTextView";
    public static final boolean DEBUG = false;
    public int blockQuoteBackgroundColor = this.getResources().getColor(R.color.White);
    public int blockQuoteStripColor = this.getResources().getColor(R.color.black);
    public float blockQuoteStripWidth = 10.0f;
    public float blockQuoteGap = 20.0f;
    @Nullable
    private ClickableTableSpan clickableTableSpan;
    @Nullable
    private DrawTableLinkSpan drawTableLinkSpan;
    @Nullable
    private OnClickATagListener onClickATagListener;
    private float indent = 24.0f;
    private boolean removeTrailingWhiteSpace = true;

    public HtmlTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public HtmlTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HtmlTextView(Context context) {
        super(context);
    }

    public void setHtml(@RawRes int resId) {
        this.setHtml(resId, null);
    }

    public void setHtml(@NonNull String html) {
        this.setHtml(html, null);
    }

    public void setHtml(@RawRes int resId, @Nullable Html.ImageGetter imageGetter) {
        InputStream inputStreamText = this.getContext().getResources().openRawResource(resId);
        this.setHtml(HtmlTextView.convertStreamToString(inputStreamText), imageGetter);
    }

    public void setHtml(@NonNull String html, @Nullable Html.ImageGetter imageGetter) {
        Spanned styledText = HtmlFormatter.formatHtml(html, imageGetter, this.clickableTableSpan, this.drawTableLinkSpan, new HtmlFormatter.TagClickListenerProvider(){

            @Override
            public OnClickATagListener provideTagClickListener() {
                return HtmlTextView.this.onClickATagListener;
            }
        }, this.indent, this.removeTrailingWhiteSpace);
        this.replaceQuoteSpans(styledText);
        this.setText((CharSequence)styledText);
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
    }

    public void setRemoveTrailingWhiteSpace(boolean removeTrailingWhiteSpace) {
        this.removeTrailingWhiteSpace = removeTrailingWhiteSpace;
    }

    public void setClickableTableSpan(@Nullable ClickableTableSpan clickableTableSpan) {
        this.clickableTableSpan = clickableTableSpan;
    }

    public void setDrawTableLinkSpan(@Nullable DrawTableLinkSpan drawTableLinkSpan) {
        this.drawTableLinkSpan = drawTableLinkSpan;
    }

    public void setOnClickATagListener(@Nullable OnClickATagListener onClickATagListener) {
        this.onClickATagListener = onClickATagListener;
    }

    public void setListIndentPx(float px) {
        this.indent = px;
    }

    @NonNull
    private static String convertStreamToString(@NonNull InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private void replaceQuoteSpans(Spanned spanned) {
        QuoteSpan[] quoteSpans;
        Spannable spannable = (Spannable)spanned;
        for (QuoteSpan quoteSpan : quoteSpans = (QuoteSpan[])spannable.getSpans(0, spannable.length() - 1, QuoteSpan.class)) {
            int start = spannable.getSpanStart((Object)quoteSpan);
            int end = spannable.getSpanEnd((Object)quoteSpan);
            int flags = spannable.getSpanFlags((Object)quoteSpan);
            spannable.removeSpan((Object)quoteSpan);
            spannable.setSpan((Object)new DesignQuoteSpan(this.blockQuoteBackgroundColor, this.blockQuoteStripColor, this.blockQuoteStripWidth, this.blockQuoteGap), start, end, flags);
        }
    }
}

