/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.text.Editable;
import android.text.Layout;
import android.text.style.AlignmentSpan;
import android.text.style.BulletSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.view.View;
import androidx.annotation.Nullable;
import java.util.Stack;
import org.sufficientlysecure.htmltextview.ClickableTableSpan;
import org.sufficientlysecure.htmltextview.DrawTableLinkSpan;
import org.sufficientlysecure.htmltextview.HtmlFormatter;
import org.sufficientlysecure.htmltextview.NumberSpan;
import org.sufficientlysecure.htmltextview.WrapperTagHandler;
import org.xml.sax.Attributes;

public class HtmlTagHandler
implements WrapperTagHandler {
    public static final String UNORDERED_LIST = "HTML_TEXTVIEW_ESCAPED_UL_TAG";
    public static final String ORDERED_LIST = "HTML_TEXTVIEW_ESCAPED_OL_TAG";
    public static final String LIST_ITEM = "HTML_TEXTVIEW_ESCAPED_LI_TAG";
    public static final String A_ITEM = "HTML_TEXTVIEW_ESCAPED_A_TAG";
    public static final String PLACEHOLDER_ITEM = "HTML_TEXTVIEW_ESCAPED_PLACEHOLDER";
    Stack<String> lists = new Stack();
    Stack<Integer> olNextIndex = new Stack();
    StringBuilder tableHtmlBuilder = new StringBuilder();
    int tableTagLevel = 0;
    private static int userGivenIndent = -1;
    private static final int defaultIndent = 10;
    private static final int defaultListItemIndent = 20;
    private static final BulletSpan defaultBullet = new BulletSpan(10);
    private ClickableTableSpan clickableTableSpan;
    private DrawTableLinkSpan drawTableLinkSpan;
    private HtmlFormatter.TagClickListenerProvider onClickATagListenerProvider;

    String overrideTags(@Nullable String html) {
        if (html == null) {
            return null;
        }
        html = "<HTML_TEXTVIEW_ESCAPED_PLACEHOLDER></HTML_TEXTVIEW_ESCAPED_PLACEHOLDER>" + html;
        html = html.replace("<ul", "<HTML_TEXTVIEW_ESCAPED_UL_TAG");
        html = html.replace("</ul>", "</HTML_TEXTVIEW_ESCAPED_UL_TAG>");
        html = html.replace("<ol", "<HTML_TEXTVIEW_ESCAPED_OL_TAG");
        html = html.replace("</ol>", "</HTML_TEXTVIEW_ESCAPED_OL_TAG>");
        html = html.replace("<li", "<HTML_TEXTVIEW_ESCAPED_LI_TAG");
        html = html.replace("</li>", "</HTML_TEXTVIEW_ESCAPED_LI_TAG>");
        html = html.replace("<a", "<HTML_TEXTVIEW_ESCAPED_A_TAG");
        html = html.replace("</a>", "</HTML_TEXTVIEW_ESCAPED_A_TAG>");
        return html;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleTag(boolean opening, String tag, Editable output, Attributes attributes) {
        if (opening) {
            if (tag.equalsIgnoreCase(UNORDERED_LIST)) {
                this.lists.push(tag);
            } else if (tag.equalsIgnoreCase(ORDERED_LIST)) {
                this.lists.push(tag);
                this.olNextIndex.push(1);
            } else if (tag.equalsIgnoreCase(LIST_ITEM)) {
                if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                    output.append((CharSequence)"\n");
                }
                if (!this.lists.isEmpty()) {
                    String parentList = this.lists.peek();
                    if (parentList.equalsIgnoreCase(ORDERED_LIST)) {
                        this.start(output, new Ol());
                        this.olNextIndex.push(this.olNextIndex.pop() + 1);
                    } else if (parentList.equalsIgnoreCase(UNORDERED_LIST)) {
                        this.start(output, new Ul());
                    }
                }
            } else if (tag.equalsIgnoreCase(A_ITEM)) {
                String href = attributes != null ? attributes.getValue("href") : null;
                this.start(output, new A(output.toString(), href));
            } else if (tag.equalsIgnoreCase("code")) {
                this.start(output, new Code());
            } else if (tag.equalsIgnoreCase("center")) {
                this.start(output, new Center());
            } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
                this.start(output, new Strike());
            } else if (tag.equalsIgnoreCase("table")) {
                this.start(output, new Table());
                if (this.tableTagLevel == 0) {
                    this.tableHtmlBuilder = new StringBuilder();
                    output.append((CharSequence)"table placeholder");
                }
                ++this.tableTagLevel;
            } else if (tag.equalsIgnoreCase("tr")) {
                this.start(output, new Tr());
            } else if (tag.equalsIgnoreCase("th")) {
                this.start(output, new Th());
            } else {
                if (!tag.equalsIgnoreCase("td")) return false;
                this.start(output, new Td());
            }
        } else if (tag.equalsIgnoreCase(UNORDERED_LIST)) {
            this.lists.pop();
        } else if (tag.equalsIgnoreCase(ORDERED_LIST)) {
            this.lists.pop();
            this.olNextIndex.pop();
        } else if (tag.equalsIgnoreCase(LIST_ITEM)) {
            if (!this.lists.isEmpty()) {
                int listItemIndent;
                int n = listItemIndent = userGivenIndent > -1 ? userGivenIndent * 2 : 20;
                if (this.lists.peek().equalsIgnoreCase(UNORDERED_LIST)) {
                    BulletSpan bullet;
                    if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                        output.append((CharSequence)"\n");
                    }
                    int indent = userGivenIndent > -1 ? userGivenIndent : 10;
                    BulletSpan bulletSpan = bullet = userGivenIndent > -1 ? new BulletSpan(userGivenIndent) : defaultBullet;
                    if (this.lists.size() > 1) {
                        indent -= bullet.getLeadingMargin(true);
                        if (this.lists.size() > 2) {
                            indent -= (this.lists.size() - 2) * listItemIndent;
                        }
                    }
                    BulletSpan newBullet = new BulletSpan(indent);
                    this.end(output, Ul.class, false, new LeadingMarginSpan.Standard(listItemIndent * (this.lists.size() - 1)), newBullet);
                } else if (this.lists.peek().equalsIgnoreCase(ORDERED_LIST)) {
                    if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                        output.append((CharSequence)"\n");
                    }
                    int indent = userGivenIndent > -1 ? userGivenIndent : 10;
                    NumberSpan span = new NumberSpan(indent, (Integer)this.olNextIndex.lastElement() - 1);
                    if (this.lists.size() > 1) {
                        indent -= span.getLeadingMargin(true);
                        if (this.lists.size() > 2) {
                            indent -= (this.lists.size() - 2) * listItemIndent;
                        }
                    }
                    NumberSpan numberSpan = new NumberSpan(indent, (Integer)this.olNextIndex.lastElement() - 1);
                    this.end(output, Ol.class, false, new Object[]{new LeadingMarginSpan.Standard(listItemIndent * (this.lists.size() - 1)), numberSpan});
                }
            }
        } else if (tag.equalsIgnoreCase(A_ITEM)) {
            Object a = HtmlTagHandler.getLast(output, A.class);
            int spanStart = output.getSpanStart(a);
            int spanEnd = output.length();
            String href = a instanceof A ? ((A)a).href : null;
            final String spannedText = output.subSequence(spanStart, spanEnd).toString();
            this.end(output, A.class, false, new URLSpan(href){

                public void onClick(View widget) {
                    boolean clickConsumed;
                    if (HtmlTagHandler.this.onClickATagListenerProvider != null && !(clickConsumed = HtmlTagHandler.this.onClickATagListenerProvider.provideTagClickListener().onClick(widget, spannedText, this.getURL()))) {
                        super.onClick(widget);
                    }
                }
            });
        } else if (tag.equalsIgnoreCase("code")) {
            this.end(output, Code.class, false, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("center")) {
            this.end(output, Center.class, true, new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER));
        } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
            this.end(output, Strike.class, false, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("table")) {
            --this.tableTagLevel;
            if (this.tableTagLevel == 0) {
                String tableHtml = this.tableHtmlBuilder.toString();
                ClickableTableSpan myClickableTableSpan = null;
                if (this.clickableTableSpan != null) {
                    myClickableTableSpan = this.clickableTableSpan.newInstance();
                    myClickableTableSpan.setTableHtml(tableHtml);
                }
                DrawTableLinkSpan myDrawTableLinkSpan = null;
                if (this.drawTableLinkSpan != null) {
                    myDrawTableLinkSpan = this.drawTableLinkSpan.newInstance();
                }
                this.end(output, Table.class, false, new Object[]{myDrawTableLinkSpan, myClickableTableSpan});
            } else {
                this.end(output, Table.class, false, new Object[0]);
            }
        } else if (tag.equalsIgnoreCase("tr")) {
            this.end(output, Tr.class, false, new Object[0]);
        } else if (tag.equalsIgnoreCase("th")) {
            this.end(output, Th.class, false, new Object[0]);
        } else {
            if (!tag.equalsIgnoreCase("td")) return false;
            this.end(output, Td.class, false, new Object[0]);
        }
        this.storeTableTags(opening, tag);
        return true;
    }

    private void storeTableTags(boolean opening, String tag) {
        if (this.tableTagLevel > 0 || tag.equalsIgnoreCase("table")) {
            this.tableHtmlBuilder.append("<");
            if (!opening) {
                this.tableHtmlBuilder.append("/");
            }
            this.tableHtmlBuilder.append(tag.toLowerCase()).append(">");
        }
    }

    private void start(Editable output, Object mark) {
        int len = output.length();
        output.setSpan(mark, len, len, 17);
    }

    private void end(Editable output, Class kind, boolean paragraphStyle, Object ... replaces) {
        Object obj = HtmlTagHandler.getLast(output, kind);
        int where = output.getSpanStart(obj);
        int len = output.length();
        if (this.tableTagLevel > 0) {
            CharSequence extractedSpanText = this.extractSpanText(output, kind);
            this.tableHtmlBuilder.append(extractedSpanText);
        }
        output.removeSpan(obj);
        if (where != len) {
            int thisLen = len;
            if (paragraphStyle) {
                output.append((CharSequence)"\n");
                ++thisLen;
            }
            for (Object replace : replaces) {
                output.setSpan(replace, where, thisLen, 33);
            }
        }
    }

    private CharSequence extractSpanText(Editable output, Class kind) {
        Object obj = HtmlTagHandler.getLast(output, kind);
        int where = output.getSpanStart(obj);
        int len = output.length();
        CharSequence extractedSpanText = output.subSequence(where, len);
        output.delete(where, len);
        return extractedSpanText;
    }

    private static Object getLast(Editable text, Class kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        for (int i = objs.length; i > 0; --i) {
            if (text.getSpanFlags(objs[i - 1]) != 17) continue;
            return objs[i - 1];
        }
        return null;
    }

    public void setListIndentPx(float px) {
        userGivenIndent = Math.round(px);
    }

    public void setClickableTableSpan(ClickableTableSpan clickableTableSpan) {
        this.clickableTableSpan = clickableTableSpan;
    }

    public void setDrawTableLinkSpan(DrawTableLinkSpan drawTableLinkSpan) {
        this.drawTableLinkSpan = drawTableLinkSpan;
    }

    public void setOnClickATagListenerProvider(HtmlFormatter.TagClickListenerProvider onClickATagListenerProvider) {
        this.onClickATagListenerProvider = onClickATagListenerProvider;
    }

    private static class Td {
        private Td() {
        }
    }

    private static class Th {
        private Th() {
        }
    }

    private static class Tr {
        private Tr() {
        }
    }

    private static class Table {
        private Table() {
        }
    }

    private static class Strike {
        private Strike() {
        }
    }

    private static class Center {
        private Center() {
        }
    }

    private static class Code {
        private Code() {
        }
    }

    private static class A {
        private String text;
        private String href;

        private A(String text, String href) {
            this.text = text;
            this.href = href;
        }
    }

    private static class Ol {
        private Ol() {
        }
    }

    private static class Ul {
        private Ul() {
        }
    }
}

