/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.text.Html;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;

public class HtmlHttpImageGetter
implements Html.ImageGetter {
    private TextView container;
    private URI baseUri;
    private boolean matchParentWidth;
    private int placeHolder;
    private boolean compressImage = false;
    private int qualityImage = 50;

    public HtmlHttpImageGetter(TextView textView) {
        this.container = textView;
        this.matchParentWidth = false;
    }

    public HtmlHttpImageGetter(TextView textView, String baseUrl) {
        this.container = textView;
        if (baseUrl != null) {
            this.baseUri = URI.create(baseUrl);
        }
    }

    public HtmlHttpImageGetter(TextView textView, String baseUrl, boolean matchParentWidth) {
        this(textView, baseUrl, 0, matchParentWidth);
    }

    public HtmlHttpImageGetter(TextView textView, String baseUrl, int placeHolder, boolean matchParentWidth) {
        this.container = textView;
        this.placeHolder = placeHolder;
        this.matchParentWidth = matchParentWidth;
        if (baseUrl != null) {
            this.baseUri = URI.create(baseUrl);
        }
    }

    public void enableCompressImage(boolean enable) {
        this.enableCompressImage(enable, 50);
    }

    public void enableCompressImage(boolean enable, int quality) {
        this.compressImage = enable;
        this.qualityImage = quality;
    }

    public Drawable getDrawable(String source) {
        UrlDrawable urlDrawable = new UrlDrawable();
        if (this.placeHolder != 0) {
            Drawable placeDrawable = this.container.getContext().getResources().getDrawable(this.placeHolder);
            placeDrawable.setBounds(0, 0, placeDrawable.getIntrinsicWidth(), placeDrawable.getIntrinsicHeight());
            urlDrawable.setBounds(0, 0, placeDrawable.getIntrinsicWidth(), placeDrawable.getIntrinsicHeight());
            urlDrawable.drawable = placeDrawable;
        }
        ImageGetterAsyncTask asyncTask = new ImageGetterAsyncTask(urlDrawable, this, (View)this.container, this.matchParentWidth, this.compressImage, this.qualityImage);
        asyncTask.execute(new String[]{source});
        return urlDrawable;
    }

    public class UrlDrawable
    extends BitmapDrawable {
        protected Drawable drawable;

        public void draw(Canvas canvas) {
            if (this.drawable != null) {
                this.drawable.draw(canvas);
            }
        }
    }

    private static class ImageGetterAsyncTask
    extends AsyncTask<String, Void, Drawable> {
        private final WeakReference<UrlDrawable> drawableReference;
        private final WeakReference<HtmlHttpImageGetter> imageGetterReference;
        private final WeakReference<View> containerReference;
        private final WeakReference<Resources> resources;
        private String source;
        private boolean matchParentWidth;
        private float scale;
        private boolean compressImage = false;
        private int qualityImage = 50;

        public ImageGetterAsyncTask(UrlDrawable d, HtmlHttpImageGetter imageGetter, View container, boolean matchParentWidth, boolean compressImage, int qualityImage) {
            this.drawableReference = new WeakReference<UrlDrawable>(d);
            this.imageGetterReference = new WeakReference<HtmlHttpImageGetter>(imageGetter);
            this.containerReference = new WeakReference<View>(container);
            this.resources = new WeakReference<Resources>(container.getResources());
            this.matchParentWidth = matchParentWidth;
            this.compressImage = compressImage;
            this.qualityImage = qualityImage;
        }

        protected Drawable doInBackground(String ... params) {
            this.source = params[0];
            if (this.resources.get() != null) {
                if (this.compressImage) {
                    return this.fetchCompressedDrawable((Resources)this.resources.get(), this.source);
                }
                return this.fetchDrawable((Resources)this.resources.get(), this.source);
            }
            return null;
        }

        protected void onPostExecute(Drawable result) {
            if (result == null) {
                Log.w((String)"HtmlTextView", (String)("Drawable result is null! (source: " + this.source + ")"));
                return;
            }
            UrlDrawable urlDrawable = (UrlDrawable)((Object)this.drawableReference.get());
            if (urlDrawable == null) {
                return;
            }
            urlDrawable.setBounds(0, 0, (int)((float)result.getIntrinsicWidth() * this.scale), (int)((float)result.getIntrinsicHeight() * this.scale));
            urlDrawable.drawable = result;
            HtmlHttpImageGetter imageGetter = (HtmlHttpImageGetter)this.imageGetterReference.get();
            if (imageGetter == null) {
                return;
            }
            imageGetter.container.invalidate();
            imageGetter.container.setText(imageGetter.container.getText());
        }

        public Drawable fetchDrawable(Resources res, String urlString) {
            try {
                InputStream is = this.fetch(urlString);
                BitmapDrawable drawable = new BitmapDrawable(res, is);
                this.scale = this.getScale((Drawable)drawable);
                drawable.setBounds(0, 0, (int)((float)drawable.getIntrinsicWidth() * this.scale), (int)((float)drawable.getIntrinsicHeight() * this.scale));
                return drawable;
            }
            catch (Exception e) {
                return null;
            }
        }

        public Drawable fetchCompressedDrawable(Resources res, String urlString) {
            try {
                InputStream is = this.fetch(urlString);
                Bitmap original = new BitmapDrawable(res, is).getBitmap();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                original.compress(Bitmap.CompressFormat.JPEG, this.qualityImage, (OutputStream)out);
                original.recycle();
                is.close();
                Bitmap decoded = BitmapFactory.decodeStream((InputStream)new ByteArrayInputStream(out.toByteArray()));
                out.close();
                this.scale = this.getScale(decoded);
                BitmapDrawable b = new BitmapDrawable(res, decoded);
                b.setBounds(0, 0, (int)((float)b.getIntrinsicWidth() * this.scale), (int)((float)b.getIntrinsicHeight() * this.scale));
                return b;
            }
            catch (Exception e) {
                return null;
            }
        }

        private float getScale(Bitmap bitmap) {
            View container = (View)this.containerReference.get();
            if (container == null) {
                return 1.0f;
            }
            float maxWidth = container.getWidth();
            float originalDrawableWidth = bitmap.getWidth();
            return maxWidth / originalDrawableWidth;
        }

        private float getScale(Drawable drawable) {
            View container = (View)this.containerReference.get();
            if (!this.matchParentWidth || container == null) {
                return 1.0f;
            }
            float maxWidth = container.getWidth();
            float originalDrawableWidth = drawable.getIntrinsicWidth();
            return maxWidth / originalDrawableWidth;
        }

        private InputStream fetch(String urlString) throws IOException {
            HtmlHttpImageGetter imageGetter = (HtmlHttpImageGetter)this.imageGetterReference.get();
            if (imageGetter == null) {
                return null;
            }
            URL url = imageGetter.baseUri != null ? imageGetter.baseUri.resolve(urlString).toURL() : URI.create(urlString).toURL();
            return (InputStream)url.getContent();
        }
    }
}

