/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.text.Editable;
import android.text.Html;
import org.sufficientlysecure.htmltextview.WrapperTagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class WrapperContentHandler
implements ContentHandler,
Html.TagHandler {
    private ContentHandler mContentHandler;
    private WrapperTagHandler mTagHandler;
    private Editable mSpannableStringBuilder;

    public WrapperContentHandler(WrapperTagHandler tagHandler) {
        this.mTagHandler = tagHandler;
    }

    public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
        if (this.mContentHandler == null) {
            this.mSpannableStringBuilder = output;
            this.mContentHandler = xmlReader.getContentHandler();
            xmlReader.setContentHandler(this);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mContentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.mContentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.mContentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.mContentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.mContentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.mTagHandler.handleTag(true, localName, this.mSpannableStringBuilder, attributes)) {
            this.mContentHandler.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.mTagHandler.handleTag(false, localName, this.mSpannableStringBuilder, null)) {
            this.mContentHandler.endElement(uri, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mContentHandler.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.mContentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.mContentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.mContentHandler.skippedEntity(name);
    }
}

