/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.text.Html;
import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.sufficientlysecure.htmltextview.ClickableTableSpan;
import org.sufficientlysecure.htmltextview.DrawTableLinkSpan;
import org.sufficientlysecure.htmltextview.HtmlFormatterBuilder;
import org.sufficientlysecure.htmltextview.HtmlTagHandler;

public class HtmlFormatter {
    private HtmlFormatter() {
    }

    public static Spanned formatHtml(@NonNull HtmlFormatterBuilder builder) {
        return HtmlFormatter.formatHtml(builder.getHtml(), builder.getImageGetter(), builder.getClickableTableSpan(), builder.getDrawTableLinkSpan(), builder.getIndent(), builder.isRemoveTrailingWhiteSpace());
    }

    public static Spanned formatHtml(@Nullable String html, Html.ImageGetter imageGetter, ClickableTableSpan clickableTableSpan, DrawTableLinkSpan drawTableLinkSpan, float indent, boolean removeTrailingWhiteSpace) {
        HtmlTagHandler htmlTagHandler = new HtmlTagHandler();
        htmlTagHandler.setClickableTableSpan(clickableTableSpan);
        htmlTagHandler.setDrawTableLinkSpan(drawTableLinkSpan);
        htmlTagHandler.setListIndentPx(indent);
        html = htmlTagHandler.overrideTags(html);
        Spanned formattedHtml = removeTrailingWhiteSpace ? HtmlFormatter.removeHtmlBottomPadding(Html.fromHtml((String)html, (Html.ImageGetter)imageGetter, (Html.TagHandler)htmlTagHandler)) : Html.fromHtml((String)html, (Html.ImageGetter)imageGetter, (Html.TagHandler)htmlTagHandler);
        return formattedHtml;
    }

    @Nullable
    private static Spanned removeHtmlBottomPadding(@Nullable Spanned text) {
        if (text == null) {
            return null;
        }
        while (text.length() > 0 && text.charAt(text.length() - 1) == '\n') {
            text = (Spanned)text.subSequence(0, text.length() - 1);
        }
        return text;
    }
}

