/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.BulletSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class NumberSpan
extends BulletSpan {
    private final int mNumberGapWidth;
    private final String mNumber;
    public static final int STANDARD_GAP_WIDTH = 10;

    public NumberSpan(int gapWidth, int number) {
        this.mNumberGapWidth = gapWidth;
        this.mNumber = Integer.toString(number).concat(".");
    }

    public NumberSpan(int number) {
        this(10, number);
    }

    public NumberSpan(Parcel src) {
        super(src);
        this.mNumberGapWidth = src.readInt();
        this.mNumber = src.readString();
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mNumberGapWidth);
        dest.writeString(this.mNumber);
    }

    public int getLeadingMargin(boolean first) {
        return 20 + this.mNumberGapWidth;
    }

    public void drawLeadingMargin(@NonNull Canvas c, @NonNull Paint p, int x, int dir, int top, int baseline, int bottom, @NonNull CharSequence text, int start, int end, boolean first, @Nullable Layout l) {
        if (((Spanned)text).getSpanStart((Object)this) == start) {
            Paint.Style style = p.getStyle();
            p.setStyle(Paint.Style.FILL);
            if (c.isHardwareAccelerated()) {
                c.save();
                c.drawText(this.mNumber, (float)(x + dir), (float)baseline, p);
                c.restore();
            } else {
                c.drawText(this.mNumber, (float)(x + dir), (float)(top + bottom) / 2.0f, p);
            }
            p.setStyle(style);
        }
    }
}

