/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.text.Html;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import java.io.InputStream;
import java.util.Scanner;
import org.sufficientlysecure.htmltextview.ClickableTableSpan;
import org.sufficientlysecure.htmltextview.DrawTableLinkSpan;
import org.sufficientlysecure.htmltextview.HtmlTagHandler;
import org.sufficientlysecure.htmltextview.JellyBeanSpanFixTextView;
import org.sufficientlysecure.htmltextview.LocalLinkMovementMethod;

public class HtmlTextView
extends JellyBeanSpanFixTextView {
    public static final String TAG = "HtmlTextView";
    public static final boolean DEBUG = false;
    boolean linkHit;
    @Nullable
    private ClickableTableSpan clickableTableSpan;
    @Nullable
    private DrawTableLinkSpan drawTableLinkSpan;
    boolean dontConsumeNonUrlClicks = true;
    private boolean removeFromHtmlSpace = true;

    public HtmlTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public HtmlTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HtmlTextView(Context context) {
        super(context);
    }

    public void setHtml(@RawRes int resId) {
        this.setHtml(resId, null);
    }

    public void setHtml(@NonNull String html) {
        this.setHtml(html, null);
    }

    public void setHtml(@RawRes int resId, @Nullable Html.ImageGetter imageGetter) {
        InputStream inputStreamText = this.getContext().getResources().openRawResource(resId);
        this.setHtml(HtmlTextView.convertStreamToString(inputStreamText), imageGetter);
    }

    public void setHtml(@NonNull String html, @Nullable Html.ImageGetter imageGetter) {
        HtmlTagHandler htmlTagHandler = new HtmlTagHandler(this.getPaint());
        htmlTagHandler.setClickableTableSpan(this.clickableTableSpan);
        htmlTagHandler.setDrawTableLinkSpan(this.drawTableLinkSpan);
        html = htmlTagHandler.overrideTags(html);
        if (this.removeFromHtmlSpace) {
            this.setText(HtmlTextView.removeHtmlBottomPadding((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)imageGetter, (Html.TagHandler)htmlTagHandler)));
        } else {
            this.setText((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)imageGetter, (Html.TagHandler)htmlTagHandler));
        }
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
    }

    public void setRemoveFromHtmlSpace(boolean removeFromHtmlSpace) {
        this.removeFromHtmlSpace = removeFromHtmlSpace;
    }

    public void setClickableTableSpan(@Nullable ClickableTableSpan clickableTableSpan) {
        this.clickableTableSpan = clickableTableSpan;
    }

    public void setDrawTableLinkSpan(@Nullable DrawTableLinkSpan drawTableLinkSpan) {
        this.drawTableLinkSpan = drawTableLinkSpan;
    }

    @NonNull
    private static String convertStreamToString(@NonNull InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    @Nullable
    private static CharSequence removeHtmlBottomPadding(@Nullable CharSequence text) {
        if (text == null) {
            return null;
        }
        while (text.length() > 0 && text.charAt(text.length() - 1) == '\n') {
            text = text.subSequence(0, text.length() - 1);
        }
        return text;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.linkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.dontConsumeNonUrlClicks) {
            return this.linkHit;
        }
        return res;
    }
}

