/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;

public class DrawTableLinkSpan
extends ReplacementSpan {
    private static final String DEFAULT_TABLE_LINK_TEXT = "";
    private static float DEFAULT_TEXT_SIZE = 80.0f;
    private static int DEFAULT_TEXT_COLOR = -16776961;
    protected String mTableLinkText = "";
    protected float mTextSize = DEFAULT_TEXT_SIZE;
    protected int mTextColor = DEFAULT_TEXT_COLOR;

    public DrawTableLinkSpan newInstance() {
        DrawTableLinkSpan drawTableLinkSpan = new DrawTableLinkSpan();
        drawTableLinkSpan.setTableLinkText(this.mTableLinkText);
        drawTableLinkSpan.setTextSize(this.mTextSize);
        drawTableLinkSpan.setTextColor(this.mTextColor);
        return drawTableLinkSpan;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        int width = (int)paint.measureText(this.mTableLinkText, 0, this.mTableLinkText.length());
        this.mTextSize = paint.getTextSize();
        return width;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Paint paint2 = new Paint();
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setColor(this.mTextColor);
        paint2.setAntiAlias(true);
        paint2.setTextSize(this.mTextSize);
        canvas.drawText(this.mTableLinkText, x, (float)bottom, paint2);
    }

    public void setTableLinkText(String tableLinkText) {
        this.mTableLinkText = tableLinkText;
    }

    public void setTextSize(float textSize) {
        this.mTextSize = textSize;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
    }

    public String getTableLinkText() {
        return this.mTableLinkText;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public int getTextColor() {
        return this.mTextColor;
    }
}

