/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.text.Html;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;

public class HtmlHttpImageGetter
implements Html.ImageGetter {
    TextView container;
    URI baseUri;
    boolean matchParentWidth;

    public HtmlHttpImageGetter(TextView textView) {
        this.container = textView;
        this.matchParentWidth = false;
    }

    public HtmlHttpImageGetter(TextView textView, String baseUrl) {
        this.container = textView;
        if (baseUrl != null) {
            this.baseUri = URI.create(baseUrl);
        }
    }

    public HtmlHttpImageGetter(TextView textView, String baseUrl, boolean matchParentWidth) {
        this.container = textView;
        this.matchParentWidth = matchParentWidth;
        if (baseUrl != null) {
            this.baseUri = URI.create(baseUrl);
        }
    }

    public Drawable getDrawable(String source) {
        UrlDrawable urlDrawable = new UrlDrawable();
        ImageGetterAsyncTask asyncTask = new ImageGetterAsyncTask(urlDrawable, this, (View)this.container, this.matchParentWidth);
        asyncTask.execute(new String[]{source});
        return urlDrawable;
    }

    public class UrlDrawable
    extends BitmapDrawable {
        protected Drawable drawable;

        public void draw(Canvas canvas) {
            if (this.drawable != null) {
                this.drawable.draw(canvas);
            }
        }
    }

    private static class ImageGetterAsyncTask
    extends AsyncTask<String, Void, Drawable> {
        private final WeakReference<UrlDrawable> drawableReference;
        private final WeakReference<HtmlHttpImageGetter> imageGetterReference;
        private final WeakReference<View> containerReference;
        private String source;
        private boolean matchParentWidth;
        private float scale;

        public ImageGetterAsyncTask(UrlDrawable d, HtmlHttpImageGetter imageGetter, View container, boolean matchParentWidth) {
            this.drawableReference = new WeakReference<UrlDrawable>(d);
            this.imageGetterReference = new WeakReference<HtmlHttpImageGetter>(imageGetter);
            this.containerReference = new WeakReference<View>(container);
            this.matchParentWidth = matchParentWidth;
        }

        protected Drawable doInBackground(String ... params) {
            this.source = params[0];
            return this.fetchDrawable(this.source);
        }

        protected void onPostExecute(Drawable result) {
            if (result == null) {
                Log.w((String)"HtmlTextView", (String)("Drawable result is null! (source: " + this.source + ")"));
                return;
            }
            UrlDrawable urlDrawable = (UrlDrawable)((Object)this.drawableReference.get());
            if (urlDrawable == null) {
                return;
            }
            urlDrawable.setBounds(0, 0, (int)((float)result.getIntrinsicWidth() * this.scale), (int)((float)result.getIntrinsicHeight() * this.scale));
            urlDrawable.drawable = result;
            HtmlHttpImageGetter imageGetter = (HtmlHttpImageGetter)this.imageGetterReference.get();
            if (imageGetter == null) {
                return;
            }
            imageGetter.container.invalidate();
            imageGetter.container.setText(imageGetter.container.getText());
        }

        public Drawable fetchDrawable(String urlString) {
            try {
                InputStream is = this.fetch(urlString);
                Drawable drawable = Drawable.createFromStream((InputStream)is, (String)"src");
                this.scale = this.getScale(drawable);
                drawable.setBounds(0, 0, (int)((float)drawable.getIntrinsicWidth() * this.scale), (int)((float)drawable.getIntrinsicHeight() * this.scale));
                return drawable;
            }
            catch (Exception e) {
                return null;
            }
        }

        private float getScale(Drawable drawable) {
            View container = (View)this.containerReference.get();
            if (!this.matchParentWidth || container == null) {
                return 1.0f;
            }
            float maxWidth = container.getWidth();
            float originalDrawableWidth = drawable.getIntrinsicWidth();
            return maxWidth / originalDrawableWidth;
        }

        private InputStream fetch(String urlString) throws IOException {
            HtmlHttpImageGetter imageGetter = (HtmlHttpImageGetter)this.imageGetterReference.get();
            if (imageGetter == null) {
                return null;
            }
            URL url = imageGetter.baseUri != null ? imageGetter.baseUri.resolve(urlString).toURL() : URI.create(urlString).toURL();
            return (InputStream)url.getContent();
        }
    }
}

