/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.text.Html;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import java.io.InputStream;
import java.util.Scanner;
import org.sufficientlysecure.htmltextview.ClickableTableSpan;
import org.sufficientlysecure.htmltextview.DrawTableLinkSpan;
import org.sufficientlysecure.htmltextview.HtmlLocalImageGetter;
import org.sufficientlysecure.htmltextview.HtmlRemoteImageGetter;
import org.sufficientlysecure.htmltextview.HtmlTagHandler;
import org.sufficientlysecure.htmltextview.JellyBeanSpanFixTextView;
import org.sufficientlysecure.htmltextview.LocalLinkMovementMethod;

public class HtmlTextView
extends JellyBeanSpanFixTextView {
    public static final String TAG = "HtmlTextView";
    public static final boolean DEBUG = false;
    boolean linkHit;
    private ClickableTableSpan clickableTableSpan;
    private DrawTableLinkSpan drawTableLinkSpan;
    boolean dontConsumeNonUrlClicks = true;
    private boolean removeFromHtmlSpace = true;

    public HtmlTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public HtmlTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HtmlTextView(Context context) {
        super(context);
    }

    public void setHtml(int resId) {
        this.setHtml(resId, null);
    }

    public void setHtml(String html) {
        this.setHtml(html, null);
    }

    public void setHtml(int resId, Html.ImageGetter imageGetter) {
        InputStream inputStreamText = this.getContext().getResources().openRawResource(resId);
        this.setHtml(HtmlTextView.convertStreamToString(inputStreamText), imageGetter);
    }

    public void setHtml(String html, Html.ImageGetter imageGetter) {
        HtmlTagHandler htmlTagHandler = new HtmlTagHandler();
        htmlTagHandler.setClickableTableSpan(this.clickableTableSpan);
        htmlTagHandler.setDrawTableLinkSpan(this.drawTableLinkSpan);
        if (this.removeFromHtmlSpace) {
            this.setText(HtmlTextView.removeHtmlBottomPadding((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)imageGetter, (Html.TagHandler)htmlTagHandler)));
        } else {
            this.setText((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)imageGetter, (Html.TagHandler)htmlTagHandler));
        }
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
    }

    public void setRemoveFromHtmlSpace(boolean removeFromHtmlSpace) {
        this.removeFromHtmlSpace = removeFromHtmlSpace;
    }

    public void setClickableTableSpan(ClickableTableSpan clickableTableSpan) {
        this.clickableTableSpan = clickableTableSpan;
    }

    public void setDrawTableLinkSpan(DrawTableLinkSpan drawTableLinkSpan) {
        this.drawTableLinkSpan = drawTableLinkSpan;
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static CharSequence removeHtmlBottomPadding(CharSequence text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return text;
        }
        while (text.charAt(text.length() - 1) == '\n') {
            text = text.subSequence(0, text.length() - 1);
        }
        return text;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.linkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.dontConsumeNonUrlClicks) {
            return this.linkHit;
        }
        return res;
    }

    @Deprecated
    public void setHtmlFromRawResource(Context context, int resId, DeprecatedImageGetter imageGetter) {
        InputStream inputStreamText = context.getResources().openRawResource(resId);
        this.setHtmlFromString(HtmlTextView.convertStreamToString(inputStreamText), imageGetter);
    }

    @Deprecated
    public void setHtmlFromString(String html, DeprecatedImageGetter imageGetter) {
        Object htmlImageGetter;
        if (imageGetter instanceof LocalImageGetter) {
            htmlImageGetter = new HtmlLocalImageGetter(this);
        } else if (imageGetter instanceof RemoteImageGetter) {
            htmlImageGetter = new HtmlRemoteImageGetter(this, ((RemoteImageGetter)imageGetter).baseUrl, ((RemoteImageGetter)imageGetter).matchParentWidth);
        } else {
            Log.e((String)TAG, (String)"Wrong imageGetter!");
            return;
        }
        this.setHtml(html, (Html.ImageGetter)htmlImageGetter);
    }

    @Deprecated
    public void setHtmlFromRawResource(Context context, int resId, boolean useLocalDrawables) {
        if (useLocalDrawables) {
            this.setHtmlFromRawResource(context, resId, new LocalImageGetter());
        } else {
            this.setHtmlFromRawResource(context, resId, new RemoteImageGetter());
        }
    }

    @Deprecated
    public void setHtmlFromString(String html, boolean useLocalDrawables) {
        if (useLocalDrawables) {
            this.setHtmlFromString(html, new LocalImageGetter());
        } else {
            this.setHtmlFromString(html, new RemoteImageGetter());
        }
    }

    @Deprecated
    public static class RemoteImageGetter
    implements DeprecatedImageGetter {
        public String baseUrl;
        public boolean matchParentWidth = false;

        public RemoteImageGetter() {
        }

        public RemoteImageGetter(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public RemoteImageGetter(String baseUrl, boolean matchParentWidth) {
            this(baseUrl);
            this.matchParentWidth = matchParentWidth;
        }

        public RemoteImageGetter(boolean matchParentWidth) {
            this.matchParentWidth = matchParentWidth;
        }
    }

    @Deprecated
    public static class LocalImageGetter
    implements DeprecatedImageGetter {
    }

    @Deprecated
    public static interface DeprecatedImageGetter {
    }
}

