/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.text.Html;
import android.util.Log;
import android.view.View;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;

public class HtmlRemoteImageGetter
implements Html.ImageGetter {
    View container;
    URI baseUri;

    public HtmlRemoteImageGetter(View t, String baseUrl) {
        this.container = t;
        if (baseUrl != null) {
            this.baseUri = URI.create(baseUrl);
        }
    }

    public Drawable getDrawable(String source) {
        UrlDrawable urlDrawable = new UrlDrawable();
        ImageGetterAsyncTask asyncTask = new ImageGetterAsyncTask(urlDrawable, this);
        asyncTask.execute(new String[]{source});
        return urlDrawable;
    }

    public class UrlDrawable
    extends BitmapDrawable {
        protected Drawable drawable;

        public void draw(Canvas canvas) {
            if (this.drawable != null) {
                this.drawable.draw(canvas);
            }
        }
    }

    private static class ImageGetterAsyncTask
    extends AsyncTask<String, Void, Drawable> {
        private final WeakReference<UrlDrawable> drawableReference;
        private final WeakReference<HtmlRemoteImageGetter> imageGetterReference;
        private String source;

        public ImageGetterAsyncTask(UrlDrawable d, HtmlRemoteImageGetter imageGetter) {
            this.drawableReference = new WeakReference<UrlDrawable>(d);
            this.imageGetterReference = new WeakReference<HtmlRemoteImageGetter>(imageGetter);
        }

        protected Drawable doInBackground(String ... params) {
            this.source = params[0];
            return this.fetchDrawable(this.source);
        }

        protected void onPostExecute(Drawable result) {
            if (result == null) {
                Log.w((String)"HtmlTextView", (String)("Drawable result is null! (source: " + this.source + ")"));
                return;
            }
            UrlDrawable urlDrawable = (UrlDrawable)((Object)this.drawableReference.get());
            if (urlDrawable == null) {
                return;
            }
            urlDrawable.setBounds(0, 0, 0 + result.getIntrinsicWidth(), 0 + result.getIntrinsicHeight());
            urlDrawable.drawable = result;
            HtmlRemoteImageGetter imageGetter = (HtmlRemoteImageGetter)this.imageGetterReference.get();
            if (imageGetter == null) {
                return;
            }
            imageGetter.container.invalidate();
        }

        public Drawable fetchDrawable(String urlString) {
            try {
                InputStream is = this.fetch(urlString);
                Drawable drawable = Drawable.createFromStream((InputStream)is, (String)"src");
                drawable.setBounds(0, 0, 0 + drawable.getIntrinsicWidth(), 0 + drawable.getIntrinsicHeight());
                return drawable;
            }
            catch (Exception e) {
                return null;
            }
        }

        private InputStream fetch(String urlString) throws IOException {
            HtmlRemoteImageGetter imageGetter = (HtmlRemoteImageGetter)this.imageGetterReference.get();
            if (imageGetter == null) {
                return null;
            }
            URL url = imageGetter.baseUri != null ? imageGetter.baseUri.resolve(urlString).toURL() : URI.create(urlString).toURL();
            return (InputStream)url.getContent();
        }
    }
}

