/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.text.Html;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.io.InputStream;
import java.util.Scanner;
import org.sufficientlysecure.htmltextview.ClickableTableSpan;
import org.sufficientlysecure.htmltextview.DrawTableLinkSpan;
import org.sufficientlysecure.htmltextview.HtmlLocalImageGetter;
import org.sufficientlysecure.htmltextview.HtmlRemoteImageGetter;
import org.sufficientlysecure.htmltextview.HtmlTagHandler;
import org.sufficientlysecure.htmltextview.JellyBeanSpanFixTextView;
import org.sufficientlysecure.htmltextview.LocalLinkMovementMethod;

public class HtmlTextView
extends JellyBeanSpanFixTextView {
    public static final String TAG = "HtmlTextView";
    public static final boolean DEBUG = false;
    boolean mDontConsumeNonUrlClicks = true;
    boolean mLinkHit;
    private ClickableTableSpan mClickableTableSpan;
    private DrawTableLinkSpan mDrawTableLinkSpan;

    public HtmlTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public HtmlTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HtmlTextView(Context context) {
        super(context);
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mLinkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.mDontConsumeNonUrlClicks) {
            return this.mLinkHit;
        }
        return res;
    }

    public void setHtmlFromRawResource(Context context, int resId, ImageGetter imageGetter) {
        InputStream inputStreamText = context.getResources().openRawResource(resId);
        this.setHtmlFromString(HtmlTextView.convertStreamToString(inputStreamText), imageGetter);
    }

    public void setHtmlFromString(String html, ImageGetter imageGetter) {
        Object htmlImageGetter;
        if (imageGetter instanceof LocalImageGetter) {
            htmlImageGetter = new HtmlLocalImageGetter(this.getContext());
        } else if (imageGetter instanceof RemoteImageGetter) {
            htmlImageGetter = new HtmlRemoteImageGetter((View)this, ((RemoteImageGetter)imageGetter).baseUrl);
        } else {
            Log.e((String)TAG, (String)"Wrong imageGetter!");
            return;
        }
        HtmlTagHandler htmlTagHandler = new HtmlTagHandler();
        htmlTagHandler.setClickableTableSpan(this.mClickableTableSpan);
        htmlTagHandler.setDrawTableLinkSpan(this.mDrawTableLinkSpan);
        this.setText((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)htmlImageGetter, (Html.TagHandler)htmlTagHandler));
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
    }

    public void setHtmlFromRawResource(Context context, int resId, boolean useLocalDrawables) {
        if (useLocalDrawables) {
            this.setHtmlFromRawResource(context, resId, new LocalImageGetter());
        } else {
            this.setHtmlFromRawResource(context, resId, new RemoteImageGetter());
        }
    }

    public void setHtmlFromString(String html, boolean useLocalDrawables) {
        if (useLocalDrawables) {
            this.setHtmlFromString(html, new LocalImageGetter());
        } else {
            this.setHtmlFromString(html, new RemoteImageGetter());
        }
    }

    public void setClickableTableSpan(ClickableTableSpan clickableTableSpan) {
        this.mClickableTableSpan = clickableTableSpan;
    }

    public void setDrawTableLinkSpan(DrawTableLinkSpan drawTableLinkSpan) {
        this.mDrawTableLinkSpan = drawTableLinkSpan;
    }

    public static class RemoteImageGetter
    implements ImageGetter {
        public String baseUrl;

        public RemoteImageGetter() {
        }

        public RemoteImageGetter(String baseUrl) {
            this.baseUrl = baseUrl;
        }
    }

    public static class LocalImageGetter
    implements ImageGetter {
    }

    public static interface ImageGetter {
    }
}

