/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.style.AlignmentSpan;
import android.text.style.BulletSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.TypefaceSpan;
import java.util.Stack;
import org.xml.sax.XMLReader;

public class HtmlTagHandler
implements Html.TagHandler {
    Stack<String> lists = new Stack();
    Stack<Integer> olNextIndex = new Stack();
    private static final int indent = 10;
    private static final int listItemIndent = 20;
    private static final BulletSpan bullet = new BulletSpan(10);

    public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
        if (opening) {
            if (tag.equalsIgnoreCase("ul")) {
                this.lists.push(tag);
            } else if (tag.equalsIgnoreCase("ol")) {
                this.lists.push(tag);
                this.olNextIndex.push(1);
            } else if (tag.equalsIgnoreCase("li")) {
                String parentList;
                if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                    output.append((CharSequence)"\n");
                }
                if ((parentList = this.lists.peek()).equalsIgnoreCase("ol")) {
                    this.start(output, new Ol());
                    output.append((CharSequence)this.olNextIndex.peek().toString()).append((CharSequence)". ");
                    this.olNextIndex.push(this.olNextIndex.pop() + 1);
                } else if (parentList.equalsIgnoreCase("ul")) {
                    this.start(output, new Ul());
                }
            } else if (tag.equalsIgnoreCase("code")) {
                this.start(output, new Code());
            } else if (tag.equalsIgnoreCase("center")) {
                this.start(output, new Center());
            } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
                this.start(output, new Strike());
            }
        } else if (tag.equalsIgnoreCase("ul")) {
            this.lists.pop();
        } else if (tag.equalsIgnoreCase("ol")) {
            this.lists.pop();
            this.olNextIndex.pop();
        } else if (tag.equalsIgnoreCase("li")) {
            if (this.lists.peek().equalsIgnoreCase("ul")) {
                if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                    output.append((CharSequence)"\n");
                }
                int bulletMargin = 10;
                if (this.lists.size() > 1) {
                    bulletMargin = 10 - bullet.getLeadingMargin(true);
                    if (this.lists.size() > 2) {
                        bulletMargin -= (this.lists.size() - 2) * 20;
                    }
                }
                BulletSpan newBullet = new BulletSpan(bulletMargin);
                this.end(output, Ul.class, false, new LeadingMarginSpan.Standard(20 * (this.lists.size() - 1)), newBullet);
            } else if (this.lists.peek().equalsIgnoreCase("ol")) {
                if (output.length() > 0 && output.charAt(output.length() - 1) != '\n') {
                    output.append((CharSequence)"\n");
                }
                int numberMargin = 20 * (this.lists.size() - 1);
                if (this.lists.size() > 2) {
                    numberMargin -= (this.lists.size() - 2) * 20;
                }
                this.end(output, Ol.class, false, new LeadingMarginSpan.Standard(numberMargin));
            }
        } else if (tag.equalsIgnoreCase("code")) {
            this.end(output, Code.class, false, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("center")) {
            this.end(output, Center.class, true, new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER));
        } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
            this.end(output, Strike.class, false, new StrikethroughSpan());
        }
    }

    private void start(Editable output, Object mark) {
        int len = output.length();
        output.setSpan(mark, len, len, 17);
    }

    private void end(Editable output, Class kind, boolean paragraphStyle, Object ... replaces) {
        Object obj = HtmlTagHandler.getLast(output, kind);
        int where = output.getSpanStart(obj);
        int len = output.length();
        output.removeSpan(obj);
        if (where != len) {
            int thisLen = len;
            if (paragraphStyle) {
                output.append((CharSequence)"\n");
                ++thisLen;
            }
            for (Object replace : replaces) {
                output.setSpan(replace, where, thisLen, 33);
            }
        }
    }

    private static Object getLast(Editable text, Class kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        for (int i = objs.length; i > 0; --i) {
            if (text.getSpanFlags(objs[i - 1]) != 17) continue;
            return objs[i - 1];
        }
        return null;
    }

    private static class Strike {
        private Strike() {
        }
    }

    private static class Center {
        private Center() {
        }
    }

    private static class Code {
        private Code() {
        }
    }

    private static class Ol {
        private Ol() {
        }
    }

    private static class Ul {
        private Ul() {
        }
    }
}

