/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.text.Html;
import android.util.Log;
import android.view.View;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class HtmlRemoteImageGetter
implements Html.ImageGetter {
    Context c;
    View container;
    URI baseUri;

    public HtmlRemoteImageGetter(View t, Context c, String baseUrl) {
        this.c = c;
        this.container = t;
        if (baseUrl != null) {
            this.baseUri = URI.create(baseUrl);
        }
    }

    public Drawable getDrawable(String source) {
        UrlDrawable urlDrawable = new UrlDrawable();
        ImageGetterAsyncTask asyncTask = new ImageGetterAsyncTask(urlDrawable);
        asyncTask.execute(new String[]{source});
        return urlDrawable;
    }

    public class UrlDrawable
    extends BitmapDrawable {
        protected Drawable drawable;

        public void draw(Canvas canvas) {
            if (this.drawable != null) {
                this.drawable.draw(canvas);
            }
        }
    }

    public class ImageGetterAsyncTask
    extends AsyncTask<String, Void, Drawable> {
        UrlDrawable urlDrawable;
        String source;

        public ImageGetterAsyncTask(UrlDrawable d) {
            this.urlDrawable = d;
        }

        protected Drawable doInBackground(String ... params) {
            this.source = params[0];
            return this.fetchDrawable(this.source);
        }

        protected void onPostExecute(Drawable result) {
            if (result == null) {
                Log.w((String)"HtmlTextView", (String)("Drawable result is null! (source: " + this.source + ")"));
                return;
            }
            this.urlDrawable.setBounds(0, 0, 0 + result.getIntrinsicWidth(), 0 + result.getIntrinsicHeight());
            this.urlDrawable.drawable = result;
            HtmlRemoteImageGetter.this.container.invalidate();
        }

        public Drawable fetchDrawable(String urlString) {
            try {
                InputStream is = this.fetch(urlString);
                Drawable drawable = Drawable.createFromStream((InputStream)is, (String)"src");
                drawable.setBounds(0, 0, 0 + drawable.getIntrinsicWidth(), 0 + drawable.getIntrinsicHeight());
                return drawable;
            }
            catch (Exception e) {
                return null;
            }
        }

        private InputStream fetch(String urlString) throws IOException {
            URL url = HtmlRemoteImageGetter.this.baseUri != null ? HtmlRemoteImageGetter.this.baseUri.resolve(urlString).toURL() : URI.create(urlString).toURL();
            return (InputStream)url.getContent();
        }
    }
}

