/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public class JellyBeanSpanFixTextView
extends TextView {
    public JellyBeanSpanFixTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public JellyBeanSpanFixTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public JellyBeanSpanFixTextView(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        catch (IndexOutOfBoundsException e) {
            this.fixOnMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void fixOnMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        CharSequence text = this.getText();
        if (text instanceof Spanned) {
            SpannableStringBuilder builder = new SpannableStringBuilder(text);
            this.fixSpannedWithSpaces(builder, widthMeasureSpec, heightMeasureSpec);
        } else {
            this.fallbackToString(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void fixSpannedWithSpaces(SpannableStringBuilder builder, int widthMeasureSpec, int heightMeasureSpec) {
        long startFix = System.currentTimeMillis();
        FixingResult result = this.addSpacesAroundSpansUntilFixed(builder, widthMeasureSpec, heightMeasureSpec);
        if (result.fixed) {
            this.removeUnneededSpaces(widthMeasureSpec, heightMeasureSpec, builder, result);
        } else {
            this.fallbackToString(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private FixingResult addSpacesAroundSpansUntilFixed(SpannableStringBuilder builder, int widthMeasureSpec, int heightMeasureSpec) {
        Object[] spans = builder.getSpans(0, builder.length(), Object.class);
        ArrayList<Object> spansWithSpacesBefore = new ArrayList<Object>(spans.length);
        ArrayList<Object> spansWithSpacesAfter = new ArrayList<Object>(spans.length);
        for (Object span : spans) {
            int spanEnd;
            int spanStart = builder.getSpanStart(span);
            if (this.isNotSpace((CharSequence)builder, spanStart - 1)) {
                builder.insert(spanStart, (CharSequence)" ");
                spansWithSpacesBefore.add(span);
            }
            if (this.isNotSpace((CharSequence)builder, spanEnd = builder.getSpanEnd(span))) {
                builder.insert(spanEnd, (CharSequence)" ");
                spansWithSpacesAfter.add(span);
            }
            try {
                this.setTextAndMeasure((CharSequence)builder, widthMeasureSpec, heightMeasureSpec);
                return FixingResult.fixed(spansWithSpacesBefore, spansWithSpacesAfter);
            }
            catch (IndexOutOfBoundsException ignored) {
            }
        }
        return FixingResult.notFixed();
    }

    private boolean isNotSpace(CharSequence text, int where) {
        return where < 0 || text.charAt(where) != ' ';
    }

    private void setTextAndMeasure(CharSequence text, int widthMeasureSpec, int heightMeasureSpec) {
        this.setText(text);
        super.measure(widthMeasureSpec, heightMeasureSpec);
    }

    private void removeUnneededSpaces(int widthMeasureSpec, int heightMeasureSpec, SpannableStringBuilder builder, FixingResult result) {
        for (Object span : result.spansWithSpacesAfter) {
            int spanEnd = builder.getSpanEnd(span);
            builder.delete(spanEnd, spanEnd + 1);
            try {
                this.setTextAndMeasure((CharSequence)builder, widthMeasureSpec, heightMeasureSpec);
            }
            catch (IndexOutOfBoundsException ignored) {
                builder.insert(spanEnd, (CharSequence)" ");
            }
        }
        boolean needReset = true;
        for (Object span : result.spansWithSpacesBefore) {
            int spanStart = builder.getSpanStart(span);
            builder.delete(spanStart - 1, spanStart);
            try {
                this.setTextAndMeasure((CharSequence)builder, widthMeasureSpec, heightMeasureSpec);
                needReset = false;
            }
            catch (IndexOutOfBoundsException ignored) {
                needReset = true;
                int newSpanStart = spanStart - 1;
                builder.insert(newSpanStart, (CharSequence)" ");
            }
        }
        if (needReset) {
            this.setText((CharSequence)builder);
            super.measure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void fallbackToString(int widthMeasureSpec, int heightMeasureSpec) {
        String fallbackText = this.getText().toString();
        this.setTextAndMeasure(fallbackText, widthMeasureSpec, heightMeasureSpec);
    }

    private static class FixingResult {
        public final boolean fixed;
        public final List<Object> spansWithSpacesBefore;
        public final List<Object> spansWithSpacesAfter;

        public static FixingResult fixed(List<Object> spansWithSpacesBefore, List<Object> spansWithSpacesAfter) {
            return new FixingResult(true, spansWithSpacesBefore, spansWithSpacesAfter);
        }

        public static FixingResult notFixed() {
            return new FixingResult(false, null, null);
        }

        private FixingResult(boolean fixed, List<Object> spansWithSpacesBefore, List<Object> spansWithSpacesAfter) {
            this.fixed = fixed;
            this.spansWithSpacesBefore = spansWithSpacesBefore;
            this.spansWithSpacesAfter = spansWithSpacesAfter;
        }
    }
}

