/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.content.Context;
import android.text.Html;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.io.InputStream;
import java.util.Scanner;
import org.sufficientlysecure.htmltextview.HtmlTagHandler;
import org.sufficientlysecure.htmltextview.JellyBeanSpanFixTextView;
import org.sufficientlysecure.htmltextview.LocalImageGetter;
import org.sufficientlysecure.htmltextview.LocalLinkMovementMethod;
import org.sufficientlysecure.htmltextview.UrlImageGetter;

public class HtmlTextView
extends JellyBeanSpanFixTextView {
    public static final String TAG = "HtmlTextView";
    public static final boolean DEBUG = false;
    boolean mDontConsumeNonUrlClicks = true;
    boolean mLinkHit;

    public HtmlTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public HtmlTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HtmlTextView(Context context) {
        super(context);
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mLinkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.mDontConsumeNonUrlClicks) {
            return this.mLinkHit;
        }
        return res;
    }

    public void setHtmlFromRawResource(Context context, int id, boolean useLocalDrawables) {
        InputStream inputStreamText = context.getResources().openRawResource(id);
        this.setHtmlFromString(HtmlTextView.convertStreamToString(inputStreamText), useLocalDrawables);
    }

    public void setHtmlFromString(String html, boolean useLocalDrawables) {
        Object imgGetter = useLocalDrawables ? new LocalImageGetter(this.getContext()) : new UrlImageGetter((View)this, this.getContext());
        this.setText((CharSequence)Html.fromHtml((String)html, (Html.ImageGetter)imgGetter, (Html.TagHandler)new HtmlTagHandler()));
        this.setMovementMethod((MovementMethod)LocalLinkMovementMethod.getInstance());
    }
}

