/*
 * Decompiled with CFR 0.152.
 */
package org.sufficientlysecure.htmltextview;

import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.style.AlignmentSpan;
import android.text.style.BulletSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.TypefaceSpan;
import java.util.Vector;
import org.xml.sax.XMLReader;

public class HtmlTagHandler
implements Html.TagHandler {
    private int mListItemCount = 0;
    private Vector<String> mListParents = new Vector();

    public void handleTag(boolean opening, String tag, Editable output, XMLReader xmlReader) {
        if (opening) {
            if (tag.equalsIgnoreCase("ul") || tag.equalsIgnoreCase("ol") || tag.equalsIgnoreCase("dd")) {
                this.mListParents.add(tag);
                this.mListItemCount = 0;
            } else if (tag.equalsIgnoreCase("code")) {
                this.start(output, new Code());
            } else if (tag.equalsIgnoreCase("center")) {
                this.start(output, new Center());
            } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
                this.start(output, new Strike());
            }
        } else if (tag.equalsIgnoreCase("ul") || tag.equalsIgnoreCase("ol") || tag.equalsIgnoreCase("dd")) {
            this.mListParents.remove(tag);
            this.mListItemCount = 0;
        } else if (tag.equalsIgnoreCase("li")) {
            this.handleListTag(output);
        } else if (tag.equalsIgnoreCase("code")) {
            this.end(output, Code.class, new TypefaceSpan("monospace"), false);
        } else if (tag.equalsIgnoreCase("center")) {
            this.end(output, Center.class, new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER), true);
        } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
            this.end(output, Strike.class, new StrikethroughSpan(), false);
        }
    }

    private void start(Editable output, Object mark) {
        int len = output.length();
        output.setSpan(mark, len, len, 17);
    }

    private void end(Editable output, Class kind, Object repl, boolean paragraphStyle) {
        Object obj = this.getLast(output, kind);
        int where = output.getSpanStart(obj);
        int len = output.length();
        output.removeSpan(obj);
        if (where != len) {
            if (paragraphStyle) {
                output.append((CharSequence)"\n");
                ++len;
            }
            output.setSpan(repl, where, len, 33);
        }
    }

    private Object getLast(Editable text, Class kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        for (int i = objs.length; i > 0; --i) {
            if (text.getSpanFlags(objs[i - 1]) != 17) continue;
            return objs[i - 1];
        }
        return null;
    }

    private void handleListTag(Editable output) {
        if (this.mListParents.lastElement().equals("ul")) {
            output.append((CharSequence)"\n");
            String[] split = output.toString().split("\n");
            int lastIndex = split.length - 1;
            int start = output.length() - split[lastIndex].length() - 1;
            output.setSpan((Object)new BulletSpan(15 * this.mListParents.size()), start, output.length(), 0);
        } else if (this.mListParents.lastElement().equals("ol")) {
            ++this.mListItemCount;
            output.append((CharSequence)"\n");
            String[] split = output.toString().split("\n");
            int lastIndex = split.length - 1;
            int start = output.length() - split[lastIndex].length() - 1;
            output.insert(start, (CharSequence)(this.mListItemCount + ". "));
            output.setSpan((Object)new LeadingMarginSpan.Standard(15 * this.mListParents.size()), start, output.length(), 0);
        }
    }

    private static class Strike {
        private Strike() {
        }
    }

    private static class Center {
        private Center() {
        }
    }

    private static class Code {
        private Code() {
        }
    }
}

