/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.ssssssss.magicapi.core.annotation.MagicModule;
import org.ssssssss.magicapi.core.config.JsonCodeConstants;
import org.ssssssss.magicapi.core.config.WebSocketSessionManager;
import org.ssssssss.magicapi.core.context.RequestEntity;
import org.ssssssss.magicapi.core.event.EventAction;
import org.ssssssss.magicapi.core.event.MagicEvent;
import org.ssssssss.magicapi.core.exception.MagicAPIException;
import org.ssssssss.magicapi.core.handler.MagicWebSocketDispatcher;
import org.ssssssss.magicapi.core.interceptor.ResultProvider;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.model.JsonBean;
import org.ssssssss.magicapi.core.model.MagicNotify;
import org.ssssssss.magicapi.core.model.PathMagicEntity;
import org.ssssssss.magicapi.core.model.SelectedResource;
import org.ssssssss.magicapi.core.service.MagicAPIService;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.service.impl.RequestMagicDynamicRegistry;
import org.ssssssss.magicapi.function.model.FunctionInfo;
import org.ssssssss.magicapi.function.service.FunctionMagicDynamicRegistry;
import org.ssssssss.magicapi.utils.PathUtils;
import org.ssssssss.magicapi.utils.ScriptManager;
import org.ssssssss.magicapi.utils.SignUtils;
import org.ssssssss.script.MagicScriptContext;

@MagicModule(value="magic")
public class DefaultMagicAPIService
implements MagicAPIService,
JsonCodeConstants {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMagicAPIService.class);
    private final boolean throwException;
    private final ResultProvider resultProvider;
    private final String instanceId;
    private final MagicResourceService resourceService;
    private final ApplicationEventPublisher publisher;
    private final RequestMagicDynamicRegistry requestMagicDynamicRegistry;
    private final FunctionMagicDynamicRegistry functionMagicDynamicRegistry;
    private final String prefix;

    public DefaultMagicAPIService(ResultProvider resultProvider, String instanceId, MagicResourceService resourceService, RequestMagicDynamicRegistry requestMagicDynamicRegistry, FunctionMagicDynamicRegistry functionMagicDynamicRegistry, boolean throwException, String prefix, ApplicationEventPublisher publisher) {
        this.resultProvider = resultProvider;
        this.requestMagicDynamicRegistry = requestMagicDynamicRegistry;
        this.functionMagicDynamicRegistry = functionMagicDynamicRegistry;
        this.throwException = throwException;
        this.resourceService = resourceService;
        this.instanceId = instanceId;
        this.prefix = (String)StringUtils.defaultIfBlank((CharSequence)prefix, (CharSequence)"");
        this.publisher = publisher;
    }

    private <T> T execute(RequestEntity requestEntity, PathMagicEntity info, Map<String, Object> context) {
        MagicScriptContext scriptContext = new MagicScriptContext();
        String fullGroupName = this.resourceService.getGroupName(info.getGroupId());
        String fullGroupPath = this.resourceService.getGroupPath(info.getGroupId());
        String scriptName = PathUtils.replaceSlash(String.format("/%s/%s(/%s/%s)", fullGroupName, info.getName(), fullGroupPath, info.getPath()));
        scriptContext.setScriptName(scriptName);
        scriptContext.putMapIntoContext(context);
        if (requestEntity != null) {
            requestEntity.setMagicScriptContext(scriptContext);
        }
        return (T)ScriptManager.executeScript(info.getScript(), scriptContext);
    }

    @Override
    public <T> T execute(String method, String path, Map<String, Object> context) {
        return this.execute(null, method, path, context);
    }

    private <T> T execute(RequestEntity requestEntity, String method, String path, Map<String, Object> context) {
        String mappingKey = Objects.toString(method, "GET").toUpperCase() + ":" + PathUtils.replaceSlash(this.prefix + "/" + Objects.toString(path, ""));
        ApiInfo info = (ApiInfo)this.requestMagicDynamicRegistry.getMapping(mappingKey);
        if (info == null) {
            throw new MagicAPIException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u63a5\u53e3 [%s:%s]", method, path));
        }
        context.put("apiInfo", info);
        return this.execute(requestEntity, info, context);
    }

    @Override
    public <T> T call(String method, String path, Map<String, Object> context) {
        RequestEntity requestEntity = RequestEntity.create();
        try {
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes instanceof ServletRequestAttributes) {
                requestEntity.request(((ServletRequestAttributes)requestAttributes).getRequest()).response(((ServletRequestAttributes)requestAttributes).getResponse());
            }
            return (T)this.resultProvider.buildResult(requestEntity, this.execute(requestEntity, method, path, context));
        }
        catch (Throwable root) {
            if (this.throwException) {
                throw root;
            }
            return (T)this.resultProvider.buildResult(requestEntity, root);
        }
    }

    @Override
    public <T> T invoke(String path, Map<String, Object> context) {
        FunctionInfo functionInfo = (FunctionInfo)this.functionMagicDynamicRegistry.getMapping(path);
        if (functionInfo == null) {
            throw new MagicAPIException(String.format("\u627e\u4e0d\u5230\u5bf9\u5e94\u51fd\u6570 [%s]", path));
        }
        return this.execute(null, functionInfo, context);
    }

    @Override
    public boolean upload(InputStream inputStream, String mode) throws IOException {
        return this.resourceService.upload(inputStream, "full".equals(mode));
    }

    @Override
    public void download(String groupId, List<SelectedResource> resources, OutputStream os) throws IOException {
        this.resourceService.export(groupId, resources, os);
    }

    @Override
    public JsonBean<?> push(String target, String secretKey, String mode, List<SelectedResource> resources) {
        this.notBlank(target, TARGET_IS_REQUIRED);
        this.notBlank(secretKey, SECRET_KEY_IS_REQUIRED);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.download(null, resources, baos);
        }
        catch (IOException e) {
            return new JsonBean(-1, e.getMessage());
        }
        final byte[] bytes = baos.toByteArray();
        long timestamp = System.currentTimeMillis();
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"timestamp", (Object)timestamp);
        param.add((Object)"mode", (Object)mode);
        param.add((Object)"sign", (Object)SignUtils.sign(timestamp, secretKey, mode, bytes));
        param.add((Object)"file", (Object)new InputStreamResource(new ByteArrayInputStream(bytes)){

            public String getFilename() {
                return "magic-api.zip";
            }

            public long contentLength() {
                return bytes.length;
            }
        });
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        return (JsonBean)restTemplate.postForObject(target, (Object)new HttpEntity((Object)param, (MultiValueMap)headers), JsonBean.class, new Object[0]);
    }

    @Override
    public boolean processNotify(MagicNotify magicNotify) {
        if (magicNotify == null || this.instanceId.equals(magicNotify.getFrom())) {
            return false;
        }
        logger.debug("\u6536\u5230\u901a\u77e5\u6d88\u606f:{}", (Object)magicNotify);
        switch (magicNotify.getAction()) {
            case WS_C_S: {
                return this.processWebSocketMessageReceived(magicNotify.getClientId(), magicNotify.getContent());
            }
            case WS_S_C: {
                return this.processWebSocketSendMessage(magicNotify.getClientId(), magicNotify.getContent());
            }
            case WS_S_S: {
                return this.processWebSocketEventMessage(magicNotify.getContent());
            }
            case CLEAR: {
                this.publisher.publishEvent((Object)new MagicEvent("clear", EventAction.CLEAR, "notify"));
            }
        }
        return this.resourceService.processNotify(magicNotify);
    }

    private boolean processWebSocketSendMessage(String clientId, String content) {
        WebSocketSessionManager.sendByClientId(clientId, content);
        return true;
    }

    private boolean processWebSocketMessageReceived(String clientId, String content) {
        MagicWebSocketDispatcher.processMessageReceived(clientId, content);
        return true;
    }

    private boolean processWebSocketEventMessage(String content) {
        MagicWebSocketDispatcher.processWebSocketEventMessage(content);
        return true;
    }
}

