/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.context;

import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ssssssss.magicapi.core.model.ApiInfo;
import org.ssssssss.magicapi.core.model.DebugRequest;
import org.ssssssss.script.MagicScriptContext;

public class RequestEntity {
    private final Long requestTime = System.currentTimeMillis();
    private final String requestId = UUID.randomUUID().toString().replace("-", "");
    private ApiInfo apiInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private boolean requestedFromTest;
    private Map<String, Object> parameters;
    private Map<String, Object> pathVariables;
    private MagicScriptContext magicScriptContext;
    private Object requestBody;
    private DebugRequest debugRequest;
    private Map<String, Object> headers;

    private RequestEntity() {
    }

    public static RequestEntity create() {
        return new RequestEntity();
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public RequestEntity info(ApiInfo apiInfo) {
        this.apiInfo = apiInfo;
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public RequestEntity request(HttpServletRequest request) {
        this.request = request;
        this.debugRequest = DebugRequest.create(request);
        return this;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public RequestEntity response(HttpServletResponse response) {
        this.response = response;
        return this;
    }

    public boolean isRequestedFromTest() {
        return this.requestedFromTest;
    }

    public RequestEntity requestedFromTest(boolean requestedFromTest) {
        this.requestedFromTest = requestedFromTest;
        return this;
    }

    public boolean isRequestedFromDebug() {
        return this.requestedFromTest && !this.debugRequest.getRequestedBreakpoints().isEmpty();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public RequestEntity parameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, Object> getPathVariables() {
        return this.pathVariables;
    }

    public RequestEntity pathVariables(Map<String, Object> pathVariables) {
        this.pathVariables = pathVariables;
        return this;
    }

    public Long getRequestTime() {
        return this.requestTime;
    }

    public MagicScriptContext getMagicScriptContext() {
        return this.magicScriptContext;
    }

    public RequestEntity setMagicScriptContext(MagicScriptContext magicScriptContext) {
        this.magicScriptContext = magicScriptContext;
        return this;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public RequestEntity setHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public RequestEntity setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public DebugRequest getDebugRequest() {
        return this.debugRequest;
    }
}

