/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.model;

import org.srplib.contract.Argument;
import org.srplib.model.BeanPropertyValueAdapter;
import org.srplib.model.PropertyAdapterFactory;
import org.srplib.model.ValueModel;

public class BeanPropertyAdapterFactory<B, T>
implements PropertyAdapterFactory<T> {
    private Class<B> objectClass;
    private B object;

    public BeanPropertyAdapterFactory(Class<B> clazz) {
        Argument.checkNotNull(clazz, (String)"Can't create bean property adapter with null class!", (Object[])new Object[0]);
        this.objectClass = clazz;
    }

    public BeanPropertyAdapterFactory(B object) {
        Argument.checkNotNull(object, (String)"Can't create bean property adapter with null object!", (Object[])new Object[0]);
        this.objectClass = object.getClass();
        this.object = object;
    }

    @Override
    public ValueModel<T> newAdapter(String property) {
        return this.object != null ? BeanPropertyValueAdapter.forBean(this.object, property) : BeanPropertyValueAdapter.forClass(this.objectClass, property);
    }
}

