/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.web.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.session.ExpiringSession;
import org.springframework.session.MapSessionRepository;
import org.springframework.session.SessionRepository;
import org.springframework.session.web.http.HeaderHttpSessionStrategy;
import org.springframework.session.web.http.HttpSessionStrategy;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationStrategy;

@Configuration
@ConditionalOnProperty(value={"security.basic.enabled"})
@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    public static final Pattern AUTHORIZATION_RULE;
    @Autowired
    private ContentNegotiationStrategy contentNegotiationStrategy;
    @Value(value="${security.basic.realm}")
    private String realm;
    @Autowired
    private AuthorizationConfig config;

    @Bean
    public SessionRepository<ExpiringSession> sessionRepository() {
        return new MapSessionRepository();
    }

    @Bean
    public AuthorizationConfig config() {
        return new AuthorizationConfig();
    }

    protected void configure(HttpSecurity http) throws Exception {
        MediaTypeRequestMatcher textHtmlMatcher = new MediaTypeRequestMatcher(this.contentNegotiationStrategy, new MediaType[]{MediaType.TEXT_HTML});
        String loginPage = "/admin-ui/#/login";
        BasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new BasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName(this.realm);
        basicAuthenticationEntryPoint.afterPropertiesSet();
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry security = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/"})).authenticated().antMatchers(new String[]{"/admin-ui/**"})).permitAll().antMatchers(new String[]{"/authenticate"})).permitAll().antMatchers(new String[]{"/security/info"})).permitAll().antMatchers(new String[]{"/assets/**"})).permitAll();
        security = this.configureSimpleSecurity(security);
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)security.and()).formLogin().loginPage("/admin-ui/#/login").loginProcessingUrl("/admin-ui/login")).defaultSuccessUrl("/admin-ui/")).permitAll()).and()).logout().logoutUrl("/admin-ui/logout").logoutSuccessHandler((LogoutSuccessHandler)new HttpStatusReturningLogoutSuccessHandler()).permitAll().and()).httpBasic().and()).exceptionHandling().defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/admin-ui/#/login"), (RequestMatcher)textHtmlMatcher).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)basicAuthenticationEntryPoint, AnyRequestMatcher.INSTANCE);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.anyRequest()).denyAll();
        SessionRepositoryFilter sessionRepositoryFilter = new SessionRepositoryFilter(this.sessionRepository());
        sessionRepositoryFilter.setHttpSessionStrategy((HttpSessionStrategy)new HeaderHttpSessionStrategy());
        http.addFilterBefore((Filter)sessionRepositoryFilter, ChannelProcessingFilter.class).csrf().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
    }

    private ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry configureSimpleSecurity(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry security) {
        for (String rule : this.config.getRules()) {
            Matcher matcher = AUTHORIZATION_RULE.matcher(rule);
            Assert.isTrue((boolean)matcher.matches(), (String)String.format("Unable to parse security rule [%s], expected format is 'HTTP_METHOD ANT_PATTERN => SECURITY_ATTRIBUTE(S)'", rule));
            HttpMethod method = HttpMethod.valueOf((String)matcher.group(1));
            String urlPattern = matcher.group(2);
            String attribute = matcher.group(3);
            security = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.antMatchers(method, new String[]{urlPattern})).access(attribute);
        }
        return security;
    }

    static {
        String methodsRegex = StringUtils.arrayToDelimitedString((Object[])HttpMethod.values(), (String)"|");
        AUTHORIZATION_RULE = Pattern.compile("(" + methodsRegex + ")\\s+(.+)\\s+=>\\s+(.+)");
    }

    @ConfigurationProperties(prefix="xd.security.authorization")
    public static class AuthorizationConfig {
        private List<String> rules = new ArrayList<String>();

        public List<String> getRules() {
            return this.rules;
        }

        public void setRules(List<String> rules) {
            this.rules = rules;
        }
    }
}

