/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple.spel;

import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.xd.tuple.Tuple;

public class TuplePropertyAccessor
implements PropertyAccessor {
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Tuple.class};
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        Tuple tuple = (Tuple)target;
        if (tuple.hasFieldName(name)) {
            return true;
        }
        return this.maybeIndex(name, tuple) != null;
    }

    private Integer maybeIndex(String name, Tuple tuple) {
        Integer index = null;
        try {
            int i = Integer.parseInt(name);
            if (i > -1 && tuple.size() > i) {
                index = i;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return index;
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        Tuple tuple = (Tuple)target;
        boolean hasKey = false;
        Object value = null;
        if (tuple.hasFieldName(name)) {
            hasKey = true;
            value = tuple.getValue(name);
        } else {
            Integer index = this.maybeIndex(name, tuple);
            if (index != null) {
                hasKey = true;
                value = tuple.getValue(index);
            }
        }
        if (value == null && !hasKey) {
            throw new TupleAccessException(name);
        }
        return new TypedValue(value);
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new UnsupportedOperationException("Tuple is immutable");
    }

    private static class TupleAccessException
    extends AccessException {
        private final String name;

        public TupleAccessException(String name) {
            super(null);
            this.name = name;
        }

        public String getMessage() {
            return "Tuple does not contain a value for field name '" + this.name + "'";
        }
    }
}

