/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple.batch;

import java.text.DateFormat;
import java.util.Map;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindException;
import org.springframework.xd.tuple.DefaultTupleConversionService;
import org.springframework.xd.tuple.Tuple;
import org.springframework.xd.tuple.TupleBuilder;
import org.springframework.xd.tuple.batch.FieldSetType;

public class TupleFieldSetMapper
implements FieldSetMapper<Tuple> {
    private DateFormat dateFormat;
    private Map<String, FieldSetType> types;
    private FormattingConversionService defaultConversionService = new DefaultTupleConversionService();

    public Tuple mapFieldSet(FieldSet fieldSet) throws BindException {
        String[] names = fieldSet.getNames();
        TupleBuilder builder = TupleBuilder.tuple();
        if (this.dateFormat != null) {
            builder.setFormats(null, this.dateFormat).setConfigurableConversionService((ConfigurableConversionService)this.defaultConversionService);
        }
        for (int i = 0; i < fieldSet.getFieldCount(); ++i) {
            builder.put(names[i], this.getValue(fieldSet, names[i]));
        }
        return builder.build();
    }

    private Object getValue(FieldSet fs, String name) {
        if (!CollectionUtils.isEmpty(this.types)) {
            FieldSetType type = this.types.get(name);
            if (type == null) {
                return fs.readString(name);
            }
            if (type == FieldSetType.BIG_DECIMAL) {
                return fs.readBigDecimal(name);
            }
            if (type == FieldSetType.BOOLEAN) {
                return fs.readBoolean(name);
            }
            if (type == FieldSetType.BYTE) {
                return fs.readByte(name);
            }
            if (type == FieldSetType.CHAR) {
                return Character.valueOf(fs.readChar(name));
            }
            if (type == FieldSetType.DATE) {
                return fs.readDate(name);
            }
            if (type == FieldSetType.DOUBLE) {
                return fs.readDouble(name);
            }
            if (type == FieldSetType.FLOAT) {
                return Float.valueOf(fs.readFloat(name));
            }
            if (type == FieldSetType.INT) {
                return fs.readInt(name);
            }
            if (type == FieldSetType.LONG) {
                return fs.readLong(name);
            }
            if (type == FieldSetType.SHORT) {
                return fs.readShort(name);
            }
            if (type == FieldSetType.STRING) {
                return fs.readString(name);
            }
            throw new UnsupportedOperationException("Unable to determine the type to retrieve for " + name);
        }
        return fs.readString(name);
    }

    public void setDateFormat(DateFormat formatter) {
        this.dateFormat = formatter;
    }

    public void setTypes(Map<String, FieldSetType> types) {
        this.types = types;
    }
}

