/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.xd.tuple.Tuple;
import org.springframework.xd.tuple.TupleBuilder;

public class JsonNodeToTupleConverter
implements Converter<JsonNode, Tuple> {
    public Tuple convert(JsonNode root) {
        TupleBuilder builder = TupleBuilder.tuple();
        if (root.isValueNode()) {
            return builder.of("value", root.asText());
        }
        try {
            Iterator it = root.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String name = (String)entry.getKey();
                JsonNode node = (JsonNode)entry.getValue();
                if (node.isObject()) {
                    builder.addEntry(name, this.convert(node));
                    continue;
                }
                if (node.isArray()) {
                    builder.addEntry(name, this.nodeToList(node));
                    continue;
                }
                if (node.isNull()) {
                    builder.addEntry(name, null);
                    continue;
                }
                if (node.isBoolean()) {
                    builder.addEntry(name, node.booleanValue());
                    continue;
                }
                if (node.isNumber()) {
                    builder.addEntry(name, node.numberValue());
                    continue;
                }
                builder.addEntry(name, node.asText());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    private List<Object> nodeToList(JsonNode node) {
        ArrayList<Object> list = new ArrayList<Object>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            JsonNode item = node.get(i);
            if (item.isObject()) {
                list.add(this.convert(item));
                continue;
            }
            if (item.isArray()) {
                list.add(this.nodeToList(item));
                continue;
            }
            if (item.isNull()) {
                list.add(null);
                continue;
            }
            if (item.isBoolean()) {
                list.add(item.booleanValue());
                continue;
            }
            if (item.isNumber()) {
                list.add(item.numberValue());
                continue;
            }
            list.add(item.asText());
        }
        return list;
    }
}

