/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.MapBindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.xd.module.options.ModuleOption;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleOptionsMetadata;

public class SimpleModuleOptionsMetadata
implements ModuleOptionsMetadata {
    private Map<String, ModuleOption> options = new LinkedHashMap<String, ModuleOption>();

    public void add(ModuleOption option) {
        if (option.getDefaultValue() != null) {
            this.validateByType(option, option.getDefaultValue().toString());
        }
        this.options.put(option.getName(), option);
    }

    @Override
    public Iterator<ModuleOption> iterator() {
        return this.options.values().iterator();
    }

    @Override
    public ModuleOptions interpolate(final Map<String, String> raw) throws BindException {
        MapBindingResult bindingResult = new MapBindingResult(new HashMap(), "options");
        for (String provided : raw.keySet()) {
            if (this.options.containsKey(provided)) continue;
            bindingResult.addError((ObjectError)new FieldError("options", provided, String.format("Module option '%s' does not exist", provided)));
        }
        if (bindingResult.hasErrors()) {
            throw new BindException((BindingResult)bindingResult);
        }
        ModuleOptions moduleOptions = new ModuleOptions(){

            @Override
            public EnumerablePropertySource<?> asPropertySource() {
                return new EnumerablePropertySource<Object>(this.toString(), (Object)this){

                    public Object getProperty(String name) {
                        ModuleOption option = (ModuleOption)SimpleModuleOptionsMetadata.this.options.get(name);
                        if (option != null) {
                            String provided = (String)raw.get(name);
                            if (provided != null) {
                                SimpleModuleOptionsMetadata.this.validateByType(option, provided);
                                return provided;
                            }
                            return option.getDefaultValue();
                        }
                        return null;
                    }

                    public String[] getPropertyNames() {
                        return SimpleModuleOptionsMetadata.this.options.keySet().toArray(new String[SimpleModuleOptionsMetadata.this.options.size()]);
                    }
                };
            }
        };
        EnumerablePropertySource<?> ps = moduleOptions.asPropertySource();
        for (String name : this.options.keySet()) {
            ps.getProperty(name);
        }
        return moduleOptions;
    }

    private void validateByType(ModuleOption option, String value) {
        if (value == null || option.getType() == null) {
            return;
        }
        if (Boolean.TYPE.getName().equals(option.getType()) || Boolean.class.getName().equals(option.getType())) {
            if (!(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equals("1") || value.equals("0"))) {
                throw new RuntimeException(String.format("The value '%s' is the wrong type for option '%s'. The required type is %s.", value, option.getName(), option.getType()));
            }
        } else {
            try {
                if (Integer.TYPE.getName().equals(option.getType()) || Integer.class.getName().equals(option.getType())) {
                    Integer.parseInt(value);
                } else if (Float.TYPE.getName().equals(option.getType()) || Float.class.getName().equals(option.getType())) {
                    Float.parseFloat(value);
                } else if (Double.TYPE.getName().equals(option.getType()) || Double.class.getName().equals(option.getType())) {
                    Double.parseDouble(value);
                } else if (Short.TYPE.getName().equals(option.getType()) || Short.class.getName().equals(option.getType())) {
                    Short.parseShort(value);
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(String.format("The value '%s' is the wrong type for option '%s'. The required type is %s.", value, option.getName(), option.getType()));
            }
        }
    }
}

