/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public abstract class ModuleDefinition
implements Comparable<ModuleDefinition> {
    private String name;
    private ModuleType type;

    protected ModuleDefinition() {
    }

    protected ModuleDefinition(String name, ModuleType type) {
        Assert.hasLength((String)name, (String)"name cannot be blank");
        Assert.notNull((Object)((Object)type), (String)"type cannot be null");
        this.name = name;
        this.type = type;
    }

    @JsonIgnore
    public abstract boolean isComposed();

    public String getName() {
        return this.name;
    }

    public ModuleType getType() {
        return this.type;
    }

    @Override
    public int compareTo(ModuleDefinition other) {
        return this.getName().compareTo(other.getName());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleDefinition)) {
            return false;
        }
        ModuleDefinition that = (ModuleDefinition)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

