/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module;

import java.util.List;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;

public class CompositeModuleDefinition
extends ModuleDefinition {
    private String dslDefinition;
    private List<ModuleDefinition> children;

    private CompositeModuleDefinition() {
    }

    CompositeModuleDefinition(String name, ModuleType type, String dslDefinition, List<ModuleDefinition> children) {
        super(name, type);
        Assert.hasText((String)dslDefinition, (String)"The dsl definition for a composed module must not be blank");
        Assert.notEmpty(children, (String)"The sub-module definitions for a composed module must have at least one element");
        this.dslDefinition = dslDefinition;
        this.children = children;
    }

    @Override
    public boolean isComposed() {
        return true;
    }

    public String toString() {
        return String.format("%s (%s:%s) [%s]", new Object[]{this.getClass().getSimpleName(), this.getType(), this.getName(), this.dslDefinition});
    }

    public String getDslDefinition() {
        return this.dslDefinition;
    }

    public List<ModuleDefinition> getChildren() {
        return this.children;
    }
}

