/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.util.MimeType;

public class StringConvertingContentTypeResolver
extends DefaultContentTypeResolver {
    private ConcurrentMap<String, MimeType> mimeTypeCache = new ConcurrentHashMap<String, MimeType>();

    public MimeType resolve(MessageHeaders headers) {
        return this.resolve((Map<String, Object>)headers);
    }

    public MimeType resolve(Map<String, Object> headers) {
        Object value = headers.get("contentType");
        if (value instanceof MimeType) {
            return (MimeType)value;
        }
        if (value instanceof String) {
            MimeType mimeType = (MimeType)this.mimeTypeCache.get(value);
            if (mimeType == null) {
                String valueAsString = (String)value;
                mimeType = MimeType.valueOf((String)valueAsString);
                this.mimeTypeCache.put(valueAsString, mimeType);
            }
            return mimeType;
        }
        return this.getDefaultMimeType();
    }
}

