/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.integration.bus;

import java.util.Properties;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.integration.bus.BusProperties;

public abstract class AbstractBusPropertiesAccessor
implements BusProperties {
    private static final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    private final Properties properties;

    public AbstractBusPropertiesAccessor(Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return defaultValue;
    }

    public int getProperty(String key, int defaultValue) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            return Integer.parseInt(property);
        }
        return defaultValue;
    }

    public long getProperty(String key, long defaultValue) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            return Long.parseLong(property);
        }
        return defaultValue;
    }

    public double getProperty(String key, double defaultValue) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            return Double.parseDouble(property);
        }
        return defaultValue;
    }

    public int getConcurrency(int defaultValue) {
        return this.getProperty("concurrency", defaultValue);
    }

    public int getMaxConcurrency(int defaultValue) {
        return this.getProperty("maxConcurrency", defaultValue);
    }

    public int getMaxAttempts(int defaultValue) {
        return this.getProperty("maxAttempts", defaultValue);
    }

    public long getBackOffInitialInterval(long defaultValue) {
        return this.getProperty("backOffInitialInterval", defaultValue);
    }

    public double getBackOffMultiplier(double defaultValue) {
        return this.getProperty("backOffMultiplier", defaultValue);
    }

    public long getBackOffMaxInterval(long defaultValue) {
        return this.getProperty("backOffMaxInterval", defaultValue);
    }

    public String getPartitionKeyExtractorClass() {
        return this.getProperty("partitionKeyExtractorClass");
    }

    public Expression getPartitionKeyExpression() {
        String partionKeyExpression = this.getProperty("partitionKeyExpression");
        Expression expression = null;
        if (partionKeyExpression != null) {
            expression = spelExpressionParser.parseExpression(partionKeyExpression);
        }
        return expression;
    }

    public String getPartitionSelectorClass() {
        return this.getProperty("partitionSelectorClass");
    }

    public Expression getPartitionSelectorExpression() {
        String partionSelectorExpression = this.getProperty("partitionSelectorExpression");
        Expression expression = null;
        if (partionSelectorExpression != null) {
            expression = spelExpressionParser.parseExpression(partionSelectorExpression);
        }
        return expression;
    }

    public int getSequence() {
        return this.getProperty("sequence", 1);
    }

    public int getCount() {
        return this.getProperty("count", 1);
    }

    public int getNextModuleCount() {
        return this.getProperty("next.module.count", 1);
    }

    public int getPartitionIndex() {
        return this.getProperty("partitionIndex", -1);
    }

    public boolean isDirectBindingAllowed() {
        return this.getProperty("directBindingAllowed", false);
    }

    public boolean isBatchingEnabled(boolean defaultValue) {
        return this.getProperty("batchingEnabled", defaultValue);
    }

    public int getBatchSize(int defaultValue) {
        return this.getProperty("batchSize", defaultValue);
    }

    public int geteBatchBufferLimit(int defaultValue) {
        return this.getProperty("batchBufferLimit", defaultValue);
    }

    public long getBatchTimeout(long defaultValue) {
        return this.getProperty("batchTimeout", defaultValue);
    }

    public boolean isCompress(boolean defaultValue) {
        return this.getProperty("compress", defaultValue);
    }

    public boolean isDurable(boolean defaultValue) {
        return this.getProperty("durableSubscription", defaultValue);
    }

    protected String[] asStringArray(String value, String[] defaultValue) {
        if (StringUtils.hasText((String)value)) {
            return StringUtils.commaDelimitedListToStringArray((String)value);
        }
        return defaultValue;
    }

    public String toString() {
        return this.properties.toString();
    }
}

