/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.store;

import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.data.repository.CrudRepository;

public abstract class AbstractRepository<T, ID extends Serializable>
implements CrudRepository<T, ID> {
    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    public boolean exists(ID id) {
        return this.findOne((Serializable)id) != null;
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Serializable id : ids) {
            Object found = this.findOne(id);
            if (found == null) continue;
            result.add(found);
        }
        return result;
    }

    public void delete(Iterable<? extends T> entities) {
        for (T entity : entities) {
            this.delete(entity);
        }
    }
}

