/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.retry.RetryOperations;
import org.springframework.xd.analytics.metrics.redis.RedisRetryTemplate;

class RedisUtils {
    RedisUtils() {
    }

    static <K, V> RedisRetryTemplate<K, V> createRedisRetryTemplate(RedisConnectionFactory connectionFactory, Class<V> valueClass, RetryOperations retryOperations) {
        RedisRetryTemplate redisTemplate = new RedisRetryTemplate();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new GenericToStringSerializer(valueClass));
        redisTemplate.setExposeConnection(true);
        redisTemplate.setConnectionFactory(connectionFactory);
        redisTemplate.setRetryOperations(retryOperations);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

