/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryOperations;
import org.springframework.xd.analytics.metrics.redis.LoggingRecoveryCallback;

public class RedisRetryTemplate<K, V>
extends RedisTemplate<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(RedisRetryTemplate.class);
    private volatile RetryOperations retryOperations;
    private volatile RecoveryCallback<?> recoveryCallback = new LoggingRecoveryCallback();

    public RetryOperations RetryOperations() {
        return this.retryOperations;
    }

    public void setRetryOperations(RetryOperations retryOperations) {
        this.retryOperations = retryOperations;
    }

    public RecoveryCallback<?> getRecoveryCallback() {
        return this.recoveryCallback;
    }

    public void setRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public <T> T execute(final RedisCallback<T> action, final boolean exposeConnection, final boolean pipeline) {
        if (this.retryOperations != null) {
            try {
                return (T)this.retryOperations.execute(new RetryCallback<T, Exception>(){

                    public T doWithRetry(RetryContext context) throws Exception {
                        if (context.getRetryCount() > 0) {
                            logger.warn("Retry of Redis Operation. Retry Count = " + context.getRetryCount());
                        }
                        return RedisRetryTemplate.super.execute(action, exposeConnection, pipeline);
                    }
                }, this.recoveryCallback);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RedisSystemException("Unknown checked exception translated", (Throwable)e);
            }
        }
        return (T)super.execute(action, exposeConnection, pipeline);
    }
}

