/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.FieldValueCounter;
import org.springframework.xd.analytics.metrics.core.FieldValueCounterRepository;
import org.springframework.xd.analytics.metrics.redis.StringRedisRetryTemplate;

public class RedisFieldValueCounterRepository
implements FieldValueCounterRepository {
    private final String metricPrefix;
    private final StringRedisRetryTemplate redisTemplate;
    private static final String MARKER = "_marker_";

    public RedisFieldValueCounterRepository(RedisConnectionFactory connectionFactory, RetryOperations retryOperations) {
        this(connectionFactory, "fieldvaluecounters.", retryOperations);
    }

    public RedisFieldValueCounterRepository(RedisConnectionFactory connectionFactory, String metricPrefix, RetryOperations retryOperations) {
        Assert.notNull((Object)connectionFactory);
        Assert.hasText((String)metricPrefix, (String)"metric prefix cannot be empty");
        this.metricPrefix = metricPrefix;
        this.redisTemplate = new StringRedisRetryTemplate(connectionFactory, retryOperations);
        this.redisTemplate.setExposeConnection(true);
        this.redisTemplate.afterPropertiesSet();
    }

    public <S extends FieldValueCounter> S save(S fieldValueCounter) {
        this.delete(fieldValueCounter.getName());
        this.increment(fieldValueCounter.getName(), MARKER, 0.0);
        for (Map.Entry<String, Double> entry : fieldValueCounter.getFieldValueCount().entrySet()) {
            this.increment(fieldValueCounter.getName(), entry.getKey(), entry.getValue());
        }
        return fieldValueCounter;
    }

    public <S extends FieldValueCounter> Iterable<S> save(Iterable<S> metrics) {
        ArrayList<FieldValueCounter> results = new ArrayList<FieldValueCounter>();
        for (FieldValueCounter m : metrics) {
            results.add(this.save(m));
        }
        return results;
    }

    public void delete(String name) {
        Assert.notNull((Object)name, (String)"The name of the FieldValueCounter must not be null");
        this.redisTemplate.delete(this.getMetricKey(name));
    }

    public void delete(FieldValueCounter fieldValueCounter) {
        Assert.notNull((Object)fieldValueCounter, (String)"The FieldValueCounter must not be null");
        this.redisTemplate.delete(this.getMetricKey(fieldValueCounter.getName()));
    }

    public void delete(Iterable<? extends FieldValueCounter> fvcs) {
        for (FieldValueCounter fieldValueCounter : fvcs) {
            this.delete(fieldValueCounter);
        }
    }

    public FieldValueCounter findOne(String name) {
        Assert.notNull((Object)name, (String)"The name of the FieldValueCounter must not be null");
        String metricKey = this.getMetricKey(name);
        if (this.redisTemplate.hasKey(metricKey).booleanValue()) {
            Map<String, Double> values = this.getZSetData(metricKey);
            FieldValueCounter c = new FieldValueCounter(name, values);
            return c;
        }
        return null;
    }

    public boolean exists(String s) {
        return this.findOne(s) != null;
    }

    public List<FieldValueCounter> findAll() {
        ArrayList<FieldValueCounter> counters = new ArrayList<FieldValueCounter>();
        Set keys = this.redisTemplate.keys(this.metricPrefix + "*");
        for (String key : keys) {
            if (key.matches(this.metricPrefix + ".+?_\\d{4}\\.\\d{2}\\.\\d{2}-\\d{2}:\\d{2}") || this.redisTemplate.type(key) != DataType.ZSET) continue;
            Map<String, Double> values = this.getZSetData(key);
            String name = key.substring(this.metricPrefix.length());
            FieldValueCounter c = new FieldValueCounter(name, values);
            counters.add(c);
        }
        return counters;
    }

    public Iterable<FieldValueCounter> findAll(Iterable<String> keys) {
        ArrayList<FieldValueCounter> results = new ArrayList<FieldValueCounter>();
        for (String k : keys) {
            FieldValueCounter value = this.findOne(k);
            if (value == null) continue;
            results.add(value);
        }
        return results;
    }

    public long count() {
        return this.findAll().size();
    }

    public void deleteAll() {
        Set keys = this.redisTemplate.keys(this.metricPrefix + "*");
        if (keys.size() > 0) {
            this.redisTemplate.delete(keys);
        }
    }

    @Override
    public void increment(String counterName, String fieldName) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).incrementScore((Object)fieldName, 1.0);
    }

    public void increment(String counterName, String fieldName, double score) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).incrementScore((Object)fieldName, score);
    }

    @Override
    public void decrement(String counterName, String fieldName) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).incrementScore((Object)fieldName, -1.0);
    }

    public void decrement(String counterName, String fieldName, double score) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).incrementScore((Object)fieldName, -score);
    }

    @Override
    public void reset(String counterName, String fieldName) {
        this.redisTemplate.boundZSetOps(this.getMetricKey(counterName)).remove(new Object[]{fieldName});
    }

    protected String getMetricKey(String metricName) {
        return this.metricPrefix + metricName;
    }

    protected Map<String, Double> getZSetData(String counterKey) {
        Set rangeWithScore = this.redisTemplate.boundZSetOps(counterKey).rangeWithScores(0L, -1L);
        HashMap<String, Double> values = new HashMap<String, Double>(rangeWithScore.size());
        for (ZSetOperations.TypedTuple typedTuple : rangeWithScore) {
            if (((String)typedTuple.getValue()).equals(MARKER)) continue;
            values.put((String)typedTuple.getValue(), typedTuple.getScore());
        }
        return values;
    }
}

