/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.redis;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.Counter;
import org.springframework.xd.analytics.metrics.core.CounterRepository;
import org.springframework.xd.analytics.metrics.redis.RedisRetryTemplate;
import org.springframework.xd.analytics.metrics.redis.RedisUtils;
import org.springframework.xd.analytics.metrics.redis.StringRedisRetryTemplate;
import org.springframework.xd.store.AbstractRedisRepository;

@Qualifier(value="simple")
public class RedisCounterRepository
extends AbstractRedisRepository<Counter, String>
implements CounterRepository {
    protected ValueOperations<String, Long> longOperations;

    public RedisCounterRepository(RedisConnectionFactory redisConnectionFactory, RetryOperations retryOperations) {
        this("counters", redisConnectionFactory, retryOperations);
    }

    public RedisCounterRepository(String repoPrefix, RedisConnectionFactory redisConnectionFactory, RetryOperations retryOperations) {
        super(repoPrefix, (RedisOperations<String, String>)new StringRedisRetryTemplate(redisConnectionFactory, retryOperations));
        RedisRetryTemplate longRedisTemplate = RedisUtils.createRedisRetryTemplate(redisConnectionFactory, Long.class, retryOperations);
        this.longOperations = longRedisTemplate.opsForValue();
    }

    @Override
    protected Counter deserialize(String redisKey, String v) {
        return new Counter(redisKey, Long.valueOf(v));
    }

    @Override
    protected String serialize(Counter entity) {
        return String.valueOf(entity.getValue());
    }

    @Override
    protected String keyFor(Counter entity) {
        Assert.notNull((Object)entity);
        return entity.getName();
    }

    @Override
    protected String serializeId(String id) {
        return id;
    }

    @Override
    protected String deserializeId(String string) {
        return string;
    }

    @Override
    public long increment(String name) {
        return this.increment(name, 1L);
    }

    @Override
    public long increment(String name, long amount) {
        String redisKeyFromId = this.redisKeyFromId(name);
        this.trackMembership(redisKeyFromId);
        return this.longOperations.increment((Object)redisKeyFromId, amount);
    }

    @Override
    public long decrement(String name) {
        String redisKeyFromId = this.redisKeyFromId(name);
        this.trackMembership(redisKeyFromId);
        return this.longOperations.increment((Object)redisKeyFromId, -1L);
    }

    @Override
    public void reset(String name) {
        String redisKeyFromId = this.redisKeyFromId(name);
        this.trackMembership(redisKeyFromId);
        this.longOperations.set((Object)redisKeyFromId, (Object)0L);
    }
}

