/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.metadata;

import javax.validation.constraints.AssertFalse;
import org.springframework.xd.analytics.metrics.metadata.MetricNameMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;

@Mixin(value={MetricNameMixin.class})
public class RichGaugeSinkOptionsMetadata {
    private double alpha = -1.0;

    public double getAlpha() {
        return this.alpha;
    }

    @AssertFalse(message="must be strictly between 0 and 1, or use -1 for arithmetic mean")
    public boolean isInvalidAlpha() {
        return this.alpha != -1.0 && (this.alpha <= 0.0 || this.alpha >= 1.0);
    }

    @ModuleOption(value="smoothing constant, or -1 to use arithmetic mean")
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

