/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.metadata;

import javax.validation.constraints.AssertFalse;
import org.springframework.xd.module.options.spi.ModuleOption;

public class MetricNameMixin {
    private String name = "${xd.stream.name}";
    private String nameExpression = null;

    @ModuleOption(value="the name of the metric to contribute to (will be created if necessary)", defaultValue="${xd.stream.name}")
    public void setName(String name) {
        this.name = name;
    }

    @ModuleOption(value="a SpEL expression to compute the name of the metric to contribute to")
    public void setNameExpression(String nameExpression) {
        this.nameExpression = nameExpression;
    }

    @AssertFalse(message="only one of 'name' or 'nameExpression' is allowed")
    private boolean isInvalidName() {
        return !this.valuesAreSetToDefaults() && !(this.nameExpression != null ^ !"${xd.stream.name}".equals(this.name));
    }

    private boolean valuesAreSetToDefaults() {
        return this.nameExpression == null && "${xd.stream.name}".equals(this.name);
    }

    public String getComputedNameExpression() {
        return this.nameExpression != null ? this.nameExpression : "'" + this.name + "'";
    }
}

