/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.memory;

import java.util.Map;
import org.springframework.xd.analytics.metrics.core.FieldValueCounter;
import org.springframework.xd.analytics.metrics.core.FieldValueCounterRepository;
import org.springframework.xd.analytics.metrics.memory.InMemoryMetricRepository;

public class InMemoryFieldValueCounterRepository
extends InMemoryMetricRepository<FieldValueCounter>
implements FieldValueCounterRepository {
    @Override
    protected FieldValueCounter create(String name) {
        return new FieldValueCounter(name);
    }

    @Override
    public synchronized void increment(String name, String fieldName) {
        this.modifyFieldValue(name, fieldName, 1.0);
    }

    @Override
    public synchronized void decrement(String name, String fieldName) {
        this.modifyFieldValue(name, fieldName, -1.0);
    }

    @Override
    public void reset(String name, String fieldName) {
        FieldValueCounter counter = (FieldValueCounter)this.getOrCreate(name);
        Map<String, Double> data = counter.getFieldValueCount();
        if (data.containsKey(fieldName)) {
            data.put(fieldName, 0.0);
        }
    }

    private void modifyFieldValue(String name, String fieldName, double delta) {
        FieldValueCounter counter = (FieldValueCounter)this.getOrCreate(name);
        Map<String, Double> data = counter.getFieldValueCount();
        double count = data.containsKey(fieldName) ? data.get(fieldName) : 0.0;
        data.put(fieldName, count + delta);
        this.save(counter);
    }
}

