/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.xd.analytics.metrics.core.AggregateCount;
import org.springframework.xd.analytics.metrics.core.AggregateCountResolution;
import org.springframework.xd.analytics.metrics.core.AggregateCounterRepository;
import org.springframework.xd.analytics.metrics.core.Counter;
import org.springframework.xd.analytics.metrics.memory.InMemoryAggregateCounter;
import org.springframework.xd.store.AbstractInMemoryRepository;

@Qualifier(value="aggregate")
public class InMemoryAggregateCounterRepository
extends AbstractInMemoryRepository<Counter, String>
implements AggregateCounterRepository {
    private Map<String, InMemoryAggregateCounter> aggregates = new HashMap<String, InMemoryAggregateCounter>();

    @Override
    public long increment(String name) {
        return this.increment(name, 1L);
    }

    @Override
    public long increment(String name, long amount) {
        return this.increment(name, amount, DateTime.now());
    }

    @Override
    public long decrement(String name) {
        throw new UnsupportedOperationException("Can't decrement an AggregateCounter");
    }

    @Override
    public void reset(String name) {
        this.delete(name);
    }

    @Override
    public long increment(String name, long amount, DateTime dateTime) {
        InMemoryAggregateCounter counter = this.getOrCreate(name);
        return counter.increment(amount, dateTime);
    }

    @Override
    public AggregateCount getCounts(String name, int nCounts, AggregateCountResolution resolution) {
        return this.getOrCreate(name).getCounts(nCounts, new DateTime(), resolution);
    }

    @Override
    public AggregateCount getCounts(String name, Interval interval, AggregateCountResolution resolution) {
        return this.getOrCreate(name).getCounts(interval, resolution);
    }

    @Override
    public AggregateCount getCounts(String name, int nCounts, DateTime end, AggregateCountResolution resolution) {
        return this.getOrCreate(name).getCounts(nCounts, end, resolution);
    }

    private synchronized InMemoryAggregateCounter getOrCreate(String name) {
        InMemoryAggregateCounter c = this.aggregates.get(name);
        if (c == null) {
            c = new InMemoryAggregateCounter(name);
            this.aggregates.put(name, c);
        }
        return c;
    }

    @Override
    public <S extends Counter> S save(S entity) {
        this.aggregates.remove(entity.getName());
        this.increment(entity.getName(), (int)entity.getValue(), DateTime.now());
        return entity;
    }

    @Override
    protected String keyFor(Counter entity) {
        return entity.getName();
    }

    @Override
    public Counter findOne(String id) {
        InMemoryAggregateCounter aggregate = this.getOrCreate(id);
        return aggregate;
    }

    @Override
    public Iterable<Counter> findAll() {
        return new ArrayList<Counter>(this.aggregates.values());
    }

    @Override
    public long count() {
        return this.aggregates.size();
    }

    @Override
    public void delete(String id) {
        this.aggregates.remove(id);
    }

    @Override
    public void delete(Counter entity) {
        this.delete(entity.getName());
    }

    @Override
    public void deleteAll() {
        this.aggregates.clear();
    }
}

