/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.integration;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

abstract class AbstractMetricHandler
implements BeanFactoryAware,
InitializingBean {
    protected final Expression nameExpression;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected EvaluationContext evaluationContext = new StandardEvaluationContext();
    private boolean evalationContextSet;
    private BeanFactory beanFactory;

    protected AbstractMetricHandler(String nameExpression) {
        Assert.notNull((Object)nameExpression, (String)"Metric name expression can not be null");
        this.nameExpression = this.spelExpressionParser.parseExpression(nameExpression);
    }

    protected String computeMetricName(Message<?> message) {
        return ((CharSequence)this.nameExpression.getValue(this.evaluationContext, message, CharSequence.class)).toString();
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        Assert.notNull((Object)evaluationContext, (String)"'evaluationContext' cannot be null");
        this.evaluationContext = evaluationContext;
        this.evalationContextSet = true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.evalationContextSet) {
            this.evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.beanFactory);
        }
    }
}

