/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.Metric;

public final class FieldValueCounter
implements Metric {
    private final String name;
    private final Map<String, Double> fieldValueCount;

    public FieldValueCounter(String name) {
        Assert.notNull((Object)name);
        this.name = name;
        this.fieldValueCount = new ConcurrentHashMap<String, Double>();
    }

    @PersistenceConstructor
    public FieldValueCounter(String name, Map<String, Double> fieldValueCount) {
        Assert.notNull((Object)name);
        Assert.notNull(fieldValueCount);
        this.name = name;
        this.fieldValueCount = fieldValueCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, Double> getFieldValueCount() {
        return this.fieldValueCount;
    }

    public String toString() {
        return "FieldValueCounter [name=" + this.name + ", fieldValueCount=" + this.fieldValueCount + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValueCounter)) {
            return false;
        }
        FieldValueCounter other = (FieldValueCounter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

