/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.analytics.metrics.core;

import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.util.Assert;
import org.springframework.xd.analytics.metrics.core.Metric;

public class Counter
implements Metric {
    private final String name;
    private long value;

    public Counter(String name) {
        Assert.notNull((Object)name);
        this.name = name;
        this.value = 0L;
    }

    @PersistenceConstructor
    public Counter(String name, long value) {
        Assert.notNull((Object)name);
        this.name = name;
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public long increment(long amount) {
        return this.value += amount;
    }

    public long decrement(long amount) {
        return this.value -= amount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Counter)) {
            return false;
        }
        Counter counter = (Counter)o;
        return this.name.equals(counter.name);
    }

    public String toString() {
        return "Counter [name=" + this.name + ", value=" + this.value + "]";
    }
}

