/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.xmpp.MessageInputStream;
import org.springframework.ws.transport.xmpp.MessageOutputStream;
import org.springframework.ws.transport.xmpp.support.XmppTransportUtils;

public class XmppSenderConnection
extends AbstractSenderConnection {
    private final Message requestMessage;
    private final XMPPConnection connection;
    private Message responseMessage;
    private String messageEncoding;
    private long receiveTimeout;

    protected XmppSenderConnection(XMPPConnection connection, String to, String thread) {
        Assert.notNull((Object)connection, (String)"'connection' must not be null");
        Assert.hasLength((String)to, (String)"'to' must not be empty");
        Assert.hasLength((String)thread, (String)"'thread' must not be empty");
        this.connection = connection;
        this.requestMessage = new Message(to, Message.Type.chat);
        this.requestMessage.setThread(thread);
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }

    void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public URI getUri() throws URISyntaxException {
        return XmppTransportUtils.toUri(this.requestMessage);
    }

    public boolean hasError() {
        return XmppTransportUtils.hasError(this.responseMessage);
    }

    public String getErrorMessage() {
        return XmppTransportUtils.getErrorMessage(this.responseMessage);
    }

    protected void addRequestHeader(String name, String value) {
        XmppTransportUtils.addHeader(this.requestMessage, name, value);
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        return new MessageOutputStream(this.requestMessage, this.messageEncoding);
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.requestMessage.setFrom(this.connection.getUser());
        this.connection.sendPacket((Packet)this.requestMessage);
    }

    protected void onReceiveBeforeRead() throws IOException {
        Packet packet;
        PacketFilter packetFilter = this.createPacketFilter();
        PacketCollector collector = this.connection.createPacketCollector(packetFilter);
        Packet packet2 = packet = this.receiveTimeout >= 0L ? collector.nextResult(this.receiveTimeout) : collector.nextResult();
        if (packet instanceof Message) {
            this.responseMessage = (Message)packet;
        } else if (packet != null) {
            throw new IllegalArgumentException("Wrong packet type: [" + packet.getClass() + "]. Only Messages can be handled.");
        }
    }

    private PacketFilter createPacketFilter() {
        AndFilter andFilter = new AndFilter();
        andFilter.addFilter((PacketFilter)new PacketTypeFilter(Message.class));
        andFilter.addFilter((PacketFilter)new ThreadFilter(this.requestMessage.getThread()));
        return andFilter;
    }

    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    protected Iterator<String> getResponseHeaderNames() {
        return XmppTransportUtils.getHeaderNames(this.responseMessage);
    }

    protected Iterator<String> getResponseHeaders(String name) throws IOException {
        return XmppTransportUtils.getHeaders(this.responseMessage, name);
    }

    protected InputStream getResponseInputStream() throws IOException {
        return new MessageInputStream(this.responseMessage, this.messageEncoding);
    }
}

