/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.x509.populator;

import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.x509.X509AuthoritiesPopulator;

public class DaoX509AuthoritiesPopulator
implements X509AuthoritiesPopulator,
InitializingBean,
MessageSourceAware {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private Pattern subjectDNPattern;
    private String subjectDNRegex = "CN=(.*?),";
    private UserDetailsService userDetailsService;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"An authenticationDao must be set");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        this.subjectDNPattern = Pattern.compile(this.subjectDNRegex, 2);
    }

    @Override
    public UserDetails getUserDetails(X509Certificate clientCert) throws AuthenticationException {
        String subjectDN = clientCert.getSubjectX500Principal().getName();
        Matcher matcher = this.subjectDNPattern.matcher(subjectDN);
        if (!matcher.find()) {
            throw new BadCredentialsException(this.messages.getMessage("DaoX509AuthoritiesPopulator.noMatching", new Object[]{subjectDN}, "No matching pattern was found in subjectDN: {0}"));
        }
        if (matcher.groupCount() != 1) {
            throw new IllegalArgumentException("Regular expression must contain a single group ");
        }
        String userName = matcher.group(1);
        UserDetails user = this.userDetailsService.loadUserByUsername(userName);
        if (user == null) {
            throw new AuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
        }
        return user;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setSubjectDNRegex(String subjectDNRegex) {
        this.subjectDNRegex = subjectDNRegex;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

