/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;

public class MockValidationCallbackHandler
extends AbstractCallbackHandler {
    private boolean isValid = true;

    public MockValidationCallbackHandler() {
    }

    public MockValidationCallbackHandler(boolean valid) {
        this.isValid = valid;
    }

    @Override
    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof CertificateValidationCallback) {
            CertificateValidationCallback validationCallback = (CertificateValidationCallback)callback;
            validationCallback.setValidator((CertificateValidationCallback.CertificateValidator)new MockCertificateValidator());
        } else if (callback instanceof PasswordValidationCallback) {
            PasswordValidationCallback validationCallback = (PasswordValidationCallback)callback;
            validationCallback.setValidator((PasswordValidationCallback.PasswordValidator)new MockPasswordValidator());
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    private class MockPasswordValidator
    implements PasswordValidationCallback.PasswordValidator {
        private MockPasswordValidator() {
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            return MockValidationCallbackHandler.this.isValid;
        }
    }

    private class MockCertificateValidator
    implements CertificateValidationCallback.CertificateValidator {
        private MockCertificateValidator() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            return MockValidationCallbackHandler.this.isValid;
        }
    }
}

