/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.ws.soap.security.callback.CallbackHandlerChain;

public class XwssCallbackHandlerChain
extends CallbackHandlerChain {
    public XwssCallbackHandlerChain(CallbackHandler[] callbackHandlers) {
        super(callbackHandlers);
    }

    @Override
    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof CertificateValidationCallback) {
            this.handleCertificateValidationCallback((CertificateValidationCallback)callback);
        } else if (callback instanceof PasswordValidationCallback) {
            this.handlePasswordValidationCallback((PasswordValidationCallback)callback);
        } else if (callback instanceof TimestampValidationCallback) {
            this.handleTimestampValidationCallback((TimestampValidationCallback)callback);
        } else {
            super.handleInternal(callback);
        }
    }

    private void handleCertificateValidationCallback(CertificateValidationCallback callback) {
        callback.setValidator((CertificateValidationCallback.CertificateValidator)new CertificateValidatorChain(callback));
    }

    private void handlePasswordValidationCallback(PasswordValidationCallback callback) {
        callback.setValidator((PasswordValidationCallback.PasswordValidator)new PasswordValidatorChain(callback));
    }

    private void handleTimestampValidationCallback(TimestampValidationCallback callback) {
        callback.setValidator((TimestampValidationCallback.TimestampValidator)new TimestampValidatorChain(callback));
    }

    private class CertificateValidatorChain
    implements CertificateValidationCallback.CertificateValidator {
        private CertificateValidationCallback callback;

        private CertificateValidatorChain(CertificateValidationCallback callback) {
            this.callback = callback;
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            boolean allUnsupported = true;
            for (int i = 0; i < XwssCallbackHandlerChain.this.getCallbackHandlers().length; ++i) {
                CallbackHandler callbackHandler = XwssCallbackHandlerChain.this.getCallbackHandlers()[i];
                try {
                    callbackHandler.handle(new Callback[]{this.callback});
                    allUnsupported = false;
                    if (this.callback.getResult()) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new CertificateValidationCallback.CertificateValidationException((Throwable)e);
                }
                catch (UnsupportedCallbackException e) {
                    // empty catch block
                }
            }
            return !allUnsupported;
        }
    }

    private class PasswordValidatorChain
    implements PasswordValidationCallback.PasswordValidator {
        private PasswordValidationCallback callback;

        private PasswordValidatorChain(PasswordValidationCallback callback) {
            this.callback = callback;
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            boolean allUnsupported = true;
            for (int i = 0; i < XwssCallbackHandlerChain.this.getCallbackHandlers().length; ++i) {
                CallbackHandler callbackHandler = XwssCallbackHandlerChain.this.getCallbackHandlers()[i];
                try {
                    callbackHandler.handle(new Callback[]{this.callback});
                    allUnsupported = false;
                    if (this.callback.getResult()) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new PasswordValidationCallback.PasswordValidationException((Throwable)e);
                }
                catch (UnsupportedCallbackException e) {
                    // empty catch block
                }
            }
            return !allUnsupported;
        }
    }

    private class TimestampValidatorChain
    implements TimestampValidationCallback.TimestampValidator {
        private TimestampValidationCallback callback;

        private TimestampValidatorChain(TimestampValidationCallback callback) {
            this.callback = callback;
        }

        public void validate(TimestampValidationCallback.Request request) throws TimestampValidationCallback.TimestampValidationException {
            for (int i = 0; i < XwssCallbackHandlerChain.this.getCallbackHandlers().length; ++i) {
                CallbackHandler callbackHandler = XwssCallbackHandlerChain.this.getCallbackHandlers()[i];
                try {
                    callbackHandler.handle(new Callback[]{this.callback});
                    this.callback.getResult();
                    continue;
                }
                catch (IOException e) {
                    throw new TimestampValidationCallback.TimestampValidationException((Throwable)e);
                }
                catch (UnsupportedCallbackException e) {
                    // empty catch block
                }
            }
        }
    }
}

